/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.api;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.analyzer.TaskPageDefineAnalyzer;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.activity.domain.TaskPageDefine;
import com.digiwin.athena.uibot.domain.QueryResultSet;
import com.digiwin.athena.uibot.domain.RelationTag;
import com.digiwin.athena.uibot.metadata.domain.ApiMetadata;
import com.digiwin.athena.uibot.metadata.domain.ApiMetadataCollection;
import com.digiwin.athena.uibot.metadata.domain.MetadataField;
import com.digiwin.athena.uibot.service.dealWithService.ShowFieldService;
import com.digiwin.athena.uibot.support.atdm.DataQueryService;
import com.digiwin.athena.uibot.support.atmc.AtmcService;
import com.digiwin.athena.uibot.support.atmc.domain.ActivityData;
import com.digiwin.athena.uibot.support.thememap.service.ThemeMapService;
import com.digiwin.athena.uibot.util.ApiMetadataUtil;
import com.digiwin.athena.uibot.util.ResponseWrapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/v1/bot/word-library"})
public class WordLibraryController {
    private static final Logger log = LoggerFactory.getLogger(WordLibraryController.class);
    @Resource
    private ShowFieldService showFieldService;
    @Resource
    private AtmcService atmcService;
    @Resource
    private DataQueryService dataQueryService;
    @Resource
    private TaskPageDefineAnalyzer taskPageDefineAnalyzer;
    @Resource
    private ThemeMapService themeMapService;

    @GetMapping(value={"/hiddenWord/{tmTaskId}/{tmActivityId}/{backlogId}"})
    public ResponseEntity<BaseResultDTO<List<String>>> getHiddenWord(HttpServletRequest request, @PathVariable(value="tmTaskId") String tmTaskId, @PathVariable(value="tmActivityId") String tmActivityId, @PathVariable(value="backlogId") String backlogId) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("task-detail", tmTaskId, tmActivityId, "performer", Boolean.valueOf(false));
        ActivityData activityData = this.atmcService.getTaskData(backlogId, executeContext);
        executeContext.appendTaskData(activityData);
        List taskPageDefineList = this.taskPageDefineAnalyzer.analysis(executeContext, activityData);
        if (CollectionUtils.isEmpty((Collection)taskPageDefineList)) {
            return ResponseWrapper.ok((Object)Lists.newArrayList());
        }
        TaskPageDefine pageDefine = (TaskPageDefine)taskPageDefineList.get(0);
        RelationTag relationTag = executeContext.getRelationTag();
        pageDefine.setRules(this.themeMapService.getRules(relationTag.getActivityId(), executeContext.getLocale()));
        QueryResultSet queryResultSet = this.dataQueryService.queryByPagedefineWithMetaData(pageDefine.getExecuteContext(), (PageDefine)pageDefine);
        ApiMetadataCollection apiMetadataCollection = queryResultSet.getMainQueryResult().getApiMetadataCollection();
        ApiMetadata masterApiMetadata = apiMetadataCollection.getMasterApiMetadata();
        ApiMetadataUtil.flatMetaData((ApiMetadata)masterApiMetadata);
        List responseFields = masterApiMetadata.getResponseFields();
        MetadataField rootField = (MetadataField)responseFields.get(0);
        ArrayList apiMetadata = Lists.newArrayList();
        this.getFieldNameAllLevel(rootField.getFieldMap(), (List)apiMetadata);
        return ResponseWrapper.ok((Object)this.showFieldService.getWordsByAbility(executeContext, (List)apiMetadata, queryResultSet, (PageDefine)pageDefine));
    }

    private void getFieldNameAllLevel(Map<String, MetadataField> fieldMap, List<Object> apiMetadata) {
        if (MapUtils.isEmpty(fieldMap)) {
            return;
        }
        apiMetadata.add(fieldMap.keySet());
        fieldMap.forEach((k, v) -> {
            List subFields = v.getSubFields();
            if (CollectionUtils.isEmpty((Collection)subFields)) {
                return;
            }
            for (MetadataField subField : subFields) {
                this.getFieldNameAllLevel(subField.getFieldMap(), apiMetadata);
            }
        });
    }
}

