/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.afc.model;

import com.digiwin.athena.uibot.domain.AFCOperationDTO;
import com.digiwin.athena.uibot.domain.DynamicForm;
import com.digiwin.athena.uibot.service.ReportModelClassifyService;
import com.digiwin.athena.uibot.service.ReportService;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/ai/excel/report/userModel"})
public class AFCUseModelController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private ReportModelClassifyService reportModelClassifyService;

    @PostMapping(value={"/operation"})
    public ResponseEntity<?> operReport(HttpServletRequest request, @RequestBody AFCOperationDTO afcOperationDTO) {
        return this.reportService.oper(request, afcOperationDTO);
    }

    @GetMapping(value={"/{modular}"})
    public ResponseEntity<?> queryReport(HttpServletRequest request, @PathVariable(value="modular") String modular) {
        return this.reportService.query(request, modular);
    }

    @GetMapping(value={"/{modular}/{id}"})
    public ResponseEntity<?> queryReportByCondition(HttpServletRequest request, @PathVariable(value="modular") String modular, @PathVariable(value="id") String id) {
        return this.reportService.design(request, modular, id);
    }

    @GetMapping(value={"/excelClassify"})
    public ResponseEntity<Map<String, Object>> queryExcelClassify() {
        return this.reportModelClassifyService.getDynamicForm("excel");
    }

    @GetMapping(value={"/excel/buildForm"})
    public ResponseEntity<DynamicForm> getExcelFormDynamicForm(HttpServletRequest request) {
        return this.reportModelClassifyService.buildSaveDynamicForm(request);
    }

    @GetMapping(value={"/excel/buildParamsForm/{reportCode}"})
    public ResponseEntity<DynamicForm> buildParamsForm(HttpServletRequest request, @PathVariable(value="reportCode") String reportCode) {
        return this.reportModelClassifyService.buildParamsDynamicForm(request, reportCode, "");
    }

    @GetMapping(value={"/excel/buildExcelParamsForm/{id}"})
    public ResponseEntity<DynamicForm> buildExcelParamsForm(HttpServletRequest request, @PathVariable(value="id") String id) {
        return this.reportModelClassifyService.buildParamsDynamicForm(request, "", id);
    }
}

