/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.api;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.domain.DoubleDocumentPageDefine;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.activity.domain.TaskPageDefine;
import com.digiwin.athena.uibot.domain.DynamicForm;
import com.digiwin.athena.uibot.domain.DynamicLayout;
import com.digiwin.athena.uibot.dto.DoubleDocumentPageDefineConvertor;
import com.digiwin.athena.uibot.dto.DoubleDocumentPageDefineDTO;
import com.digiwin.athena.uibot.service.BaseDataPageService;
import com.digiwin.athena.uibot.service.GeneralPageService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/v1/bot/"})
public class BaseDataPageController {
    @Autowired
    BaseDataPageService baseDataPageService;
    @Autowired
    private GeneralPageService generalPageService;
    @Autowired
    private DoubleDocumentPageDefineConvertor doubleDocumentPageDefineConvertor;

    @GetMapping(value={"template/basic-data/show/{tmActivityId}"})
    public ResponseEntity<?> basicDataTaskShow(HttpServletRequest request, @PathVariable(value="tmActivityId") String tmActivityId) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("basic-data", null, tmActivityId, "performer", Boolean.FALSE);
        DynamicForm templateForm = this.baseDataPageService.createBasicDataTaskTemplateForm(executeContext);
        return ResponseEntityWrapper.wrapperOk((Object)templateForm);
    }

    @GetMapping(value={"getTools/show/{tmActivityId}"})
    public ResponseEntity<?> getToolsShow(HttpServletRequest request, @PathVariable(value="tmActivityId") String tmActivityId) {
        ExecuteContext executeContext = new ExecuteContext();
        executeContext.appendHttpRequest(request);
        if (StringUtils.hasText((String)executeContext.getProxyToken())) {
            AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
        }
        executeContext.appendPageInfo("basic-data", null, tmActivityId, "performer", Boolean.FALSE);
        Object operations = this.baseDataPageService.getToolsShow(executeContext);
        return ResponseEntityWrapper.wrapperOk((Object)operations);
    }

    @GetMapping(value={"/basic-data/double-document/browse-page/show/{tmActivityId}"})
    public ResponseEntity<?> createDoubleDocBrowsePageTemplate(HttpServletRequest request, @PathVariable(value="tmActivityId") String tmActivityId) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("browse-page", null, tmActivityId, "performer", Boolean.FALSE);
        DynamicForm templateForm = this.baseDataPageService.creatDoubleBrowsePageBasicDataTaskTemplateForm(executeContext);
        return ResponseEntityWrapper.wrapperOk((Object)templateForm);
    }

    @PostMapping(value={"/basic-data/double-document/edit-page/show"})
    public ResponseEntity<?> createDoubleDocDetailPageTemplate(HttpServletRequest request, @RequestBody DoubleDocumentPageDefineDTO pageDefineDTO) {
        DoubleDocumentPageDefine pageDefine = this.doubleDocumentPageDefineConvertor.to(pageDefineDTO);
        ExecuteContext executeContext = pageDefine.getExecuteContext();
        if (executeContext == null) {
            executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (StringUtils.hasText((String)executeContext.getProxyToken())) {
            AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
        }
        if (pageDefine.getParameter() == null) {
            executeContext.setEditType("add");
        } else {
            executeContext.setEditType(pageDefine.getEditType());
        }
        if ("CUSTOM".equals(executeContext.getPattern())) {
            TaskPageDefine taskPageDefine = new TaskPageDefine();
            taskPageDefine.setExecuteContext(pageDefine.getExecuteContext());
            taskPageDefine.setDefaultShow(false);
            taskPageDefine.setParameter(pageDefine.getParameter());
            taskPageDefine.setSubmitType(pageDefine.getSubmitType());
            DynamicForm dynamicForm = this.generalPageService.createPage(executeContext, (PageDefine)taskPageDefine);
            return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
        }
        if (pageDefine.getParameter() != null) {
            Map parameter = null;
            for (Map.Entry stringObjectEntry : pageDefine.getParameter().entrySet()) {
                List list = JsonUtils.jsonToListObject((String)JsonUtils.objectToString(stringObjectEntry.getValue()), Map.class);
                if (!CollectionUtils.isNotEmpty((Collection)list) || list.size() <= 0) continue;
                parameter = (Map)JsonUtils.jsonToListObject((String)JsonUtils.objectToString(stringObjectEntry.getValue()), Map.class).get(0);
            }
            if (MapUtils.isNotEmpty(parameter)) {
                pageDefine.setParameter(parameter);
            }
        }
        if (pageDefine.getExecuteContext() == null) {
            return ResponseEntityWrapper.wrapperOk((Object)new DynamicForm());
        }
        String tmActivityId = pageDefine.getExecuteContext().getTmActivityId();
        executeContext.appendPageInfo("edit-page", null, tmActivityId, "performer", Boolean.FALSE);
        DynamicForm dynamicForm = this.baseDataPageService.creatDoubleEditPage(executeContext, pageDefine);
        return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
    }

    @GetMapping(value={"template/basic-data/show/{tmActivityId}/recycle"})
    public ResponseEntity<?> basicDataRecycleTaskShow(HttpServletRequest request, @PathVariable(value="tmActivityId") String tmActivityId) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.setIsRecycle(Boolean.TRUE);
        executeContext.appendPageInfo("basic-data", null, tmActivityId, "performer", Boolean.FALSE);
        DynamicForm templateForm = this.baseDataPageService.createRecycleBasicDataTaskTemplateForm(executeContext);
        return ResponseEntityWrapper.wrapperOk((Object)templateForm);
    }

    @GetMapping(value={"/basic-data/treedata-document/browse-page/show/{tmActivityId}"})
    public ResponseEntity<?> createTreeDataDocBrowsePageTemplate(HttpServletRequest request, @PathVariable(value="tmActivityId") String tmActivityId) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("browse-page", null, tmActivityId, "performer", Boolean.FALSE);
        DynamicLayout dynamicLayout = this.baseDataPageService.creatTreeDataBrowsePageBasicDataTaskTemplateForm(executeContext);
        return ResponseEntityWrapper.wrapperOk((Object)dynamicLayout);
    }
}

