/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.api;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.domain.PageDefine;
import com.digiwin.athena.uibot.activity.domain.ReportConditionPageDefine;
import com.digiwin.athena.uibot.activity.domain.TaskPageDefine;
import com.digiwin.athena.uibot.component.domain.CustomizeContainerComponent;
import com.digiwin.athena.uibot.domain.DynamicForm;
import com.digiwin.athena.uibot.dto.ReportConditionPageDefineConvertor;
import com.digiwin.athena.uibot.dto.ReportConditionPageDefineDTO;
import com.digiwin.athena.uibot.service.ConditionPageService;
import com.digiwin.athena.uibot.service.GeneralPageService;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/v1/bot/"})
public class ConditionPageController {
    @Resource
    private ConditionPageService conditionPageService;
    @Autowired
    private GeneralPageService generalPageService;
    @Autowired
    private ReportConditionPageDefineConvertor reportConditionPageDefineConvertor;

    @GetMapping(value={"template/statement/condition/show/{tmActivityId}"})
    public ResponseEntity<?> conditionPageShow(HttpServletRequest request, @PathVariable(value="tmActivityId") String tmActivityId) {
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        executeContext.appendPageInfo("condition-detail", null, tmActivityId, "performer", Boolean.FALSE);
        return ResponseEntityWrapper.wrapperOk((Object)this.conditionPageService.createConditionTemplateForm(executeContext));
    }

    @PostMapping(value={"statement/custom-statement-detail/show"})
    public ResponseEntity<?> showCustomStatementDetailPage(HttpServletRequest request, @RequestBody ReportConditionPageDefineDTO pageDefineDTO) {
        ReportConditionPageDefine pageDefine = this.reportConditionPageDefineConvertor.to(pageDefineDTO);
        ExecuteContext executeContext = pageDefine.getExecuteContext();
        if (executeContext == null) {
            executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (StringUtils.isNotBlank((String)executeContext.getProxyToken())) {
            AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
        }
        executeContext.setPattern("CUSTOM");
        TaskPageDefine taskPageDefine = new TaskPageDefine();
        taskPageDefine.setExecuteContext(pageDefine.getExecuteContext());
        taskPageDefine.setDefaultShow(false);
        taskPageDefine.setParameter(pageDefine.getParameter());
        taskPageDefine.setSubmitType(pageDefine.getSubmitType());
        DynamicForm dynamicForm = this.generalPageService.createOpenPage(executeContext, (PageDefine)taskPageDefine);
        this.regularCustomComponent(dynamicForm, pageDefine.getPageData());
        return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
    }

    @PostMapping(value={"statement/custom-condition/show"})
    public ResponseEntity<?> showCustomConditionPage(HttpServletRequest request, @RequestBody ReportConditionPageDefineDTO pageDefineDTO) {
        DynamicForm dynamicForm;
        ReportConditionPageDefine pageDefine = this.reportConditionPageDefineConvertor.to(pageDefineDTO);
        ExecuteContext executeContext = pageDefine.getExecuteContext();
        if (executeContext == null) {
            executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        } else {
            executeContext.appendHttpRequest(request);
        }
        if (StringUtils.isNotBlank((String)executeContext.getProxyToken())) {
            AppAuthContextHolder.getContext().setProxyToken(executeContext.getProxyToken());
        }
        if ("CUSTOM".equals(executeContext.getPattern())) {
            TaskPageDefine taskPageDefine = new TaskPageDefine();
            taskPageDefine.setExecuteContext(pageDefine.getExecuteContext());
            taskPageDefine.setDefaultShow(false);
            taskPageDefine.setParameter(pageDefine.getParameter());
            taskPageDefine.setSubmitType(pageDefine.getSubmitType());
            dynamicForm = this.generalPageService.createOpenPage(executeContext, (PageDefine)taskPageDefine);
            this.regularCustomComponent(dynamicForm, pageDefine.getPageData());
        } else {
            dynamicForm = new DynamicForm();
        }
        return ResponseEntityWrapper.wrapperOk((Object)dynamicForm);
    }

    private void regularCustomComponent(DynamicForm dynamicForm, Map<String, Object> pageData) {
        if (CollectionUtils.isNotEmpty((Collection)dynamicForm.getLayout()) && MapUtils.isNotEmpty(pageData) && null != pageData.get("UIBOT__schema")) {
            CustomizeContainerComponent component = (CustomizeContainerComponent)dynamicForm.getLayout().get(0);
            component.setSchema(String.valueOf(pageData.get("UIBOT__schema")));
            dynamicForm.setPageData(pageData);
        }
    }
}

