/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.api;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.SnowflakeIdWorker;
import com.digiwin.athena.uibot.config.EnhancedWordScheduler;
import com.digiwin.athena.uibot.config.FetchTagScheduler;
import com.digiwin.athena.uibot.designering.service.DesignerViewWordsService;
import com.digiwin.athena.uibot.domain.word.RotCategory;
import com.digiwin.athena.uibot.mapper.RotCategoryMapper;
import com.digiwin.athena.uibot.service.WordService;
import com.digiwin.athena.uibot.util.ResponseWrapper;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/tool/"})
public class ToolController {
    private static final Logger log = LoggerFactory.getLogger(ToolController.class);
    @Resource
    private RotCategoryMapper rotCategoryMapper;
    @Resource
    private DesignerViewWordsService designerViewWordsService;
    @Resource
    private EnhancedWordScheduler enhancedWordScheduler;
    @Resource
    private FetchTagScheduler fetchTagScheduler;
    @Resource
    private WordService wordService;
    public static final String INSERT_CATEGORY = "INSERT INTO `rot_category` (`code`, `parent_code`,`name`, `level`, `source`, `status`, create_user_id, modify_user_id) VALUES ('%s', '%s', '%s', '%s', 1, 0, 'athenaAdmin', 'athenaAdmin');";
    public static final String NAME = "{\"zh_TW\": \"%s\",\"zh_CN\": \"%s\",\"en_US\": \"%s\"}";
    public static final String NAME_CN = ",\"zh_CN\": \"%s\",";

    @GetMapping(value={"/logback/test"})
    public String test() {
        log.error("====== error");
        log.warn("====== warn");
        log.info("====== info");
        log.debug("====== debug");
        return "success";
    }

    @GetMapping(value={"/logback/{level}/{packageName}", "/logback/{level}"})
    public String updateLogbackLevel(@PathVariable(value="level") String level, @PathVariable(value="packageName", required=false) String packageName) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        if (StringUtils.isEmpty((CharSequence)packageName)) {
            packageName = "root";
        }
        loggerContext.getLogger(packageName).setLevel(Level.valueOf((String)level));
        return "success";
    }

    @PostMapping(value={"/word/orderTag/import"})
    public ResponseEntity<BaseResultDTO<Integer>> importWordOrderTag(@RequestParam(value="file") MultipartFile excel) {
        return ResponseWrapper.ok((Object)this.designerViewWordsService.importWordOrderTag(excel));
    }

    @PostMapping(value={"/word/orderTag/category/import"})
    public ResponseEntity<BaseResultDTO<Integer>> importWordOrderTagCategory(@RequestParam(value="file") MultipartFile excel) {
        return ResponseWrapper.ok((Object)this.designerViewWordsService.importWordOrderTagCategory(excel));
    }

    @PostMapping(value={"/word/category/updateName"})
    @Transactional
    public ResponseEntity<BaseResultDTO<Integer>> updateWordCategoryName(@RequestParam(value="file") MultipartFile excel) {
        InputStream inputStream = excel.getInputStream();
        ExcelReader reader = ExcelUtil.getReader((InputStream)inputStream);
        List sheets = reader.getSheets();
        Sheet sheet1 = (Sheet)sheets.get(0);
        int lastRowNum = sheet1.getLastRowNum() + 1;
        int count = 0;
        for (int i = 1; i < lastRowNum; ++i) {
            Row row = sheet1.getRow(i);
            String level1 = row.getCell(1).getStringCellValue();
            String level2 = row.getCell(2).getStringCellValue();
            if (StringUtils.isNotEmpty((CharSequence)level1)) {
                String level1Fan = row.getCell(3).getStringCellValue();
                String level1Eng = row.getCell(5).getStringCellValue();
                String name1 = String.format(NAME, level1Fan, level1, level1Eng);
                String sqlFormat1 = "update rot_category set name='{}' where level=1 and name like '%{}%'";
                String sql1 = StrUtil.format((CharSequence)sqlFormat1, (Object[])new Object[]{name1, String.format(NAME_CN, level1)});
                count += this.rotCategoryMapper.userDefinedSql(sql1);
            }
            if (!StringUtils.isNotEmpty((CharSequence)level2)) continue;
            String level2Fan = row.getCell(4).getStringCellValue();
            String level2Eng = row.getCell(6).getStringCellValue();
            String name2 = String.format(NAME, level2Fan, level2, level2Eng);
            String sqlFormat2 = "update rot_category set name='{}' where level=2 and name like '%{}%'";
            String sql2 = StrUtil.format((CharSequence)sqlFormat2, (Object[])new Object[]{name2, String.format(NAME_CN, level2)});
            count += this.rotCategoryMapper.userDefinedSql(sql2);
        }
        log.info("Total row: {}, update count: {}", (Object)(lastRowNum - 1), (Object)count);
        return ResponseWrapper.ok((Object)count);
    }

    @PostMapping(value={"/word/adjustCategory/import"})
    @Transactional
    public ResponseEntity<BaseResultDTO<Integer>> importAdjustCategory(@RequestParam(value="file") MultipartFile excel) {
        String nameFormat = NAME_CN;
        Map<String, List<String>> categoryFromExcel = this.collectCategoryFromExcel(excel);
        int countDiff2 = 0;
        LinkedHashMap<String, String> cate2CodeMap = new LinkedHashMap<String, String>();
        HashMap<String, Object> newCategoryMap = new HashMap<String, Object>();
        ArrayList removeCate2CodeList = Lists.newArrayList();
        for (Map.Entry<String, List<String>> entry : categoryFromExcel.entrySet()) {
            String cate12 = entry.getKey();
            List<String> cate2List2 = entry.getValue();
            RotCategory rotCategory1 = (RotCategory)this.rotCategoryMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(RotCategory.class).eq(RotCategory::getLevel, (Object)1)).like(RotCategory::getName, (Object)String.format(nameFormat, cate12)));
            if (rotCategory1 == null) {
                newCategoryMap.put(cate12, cate2List2);
                continue;
            }
            List childCategoryList = this.rotCategoryMapper.selectList((Wrapper)Wrappers.lambdaQuery(RotCategory.class).eq(RotCategory::getParentCode, (Object)rotCategory1.getCode()));
            Map oriNameMap = childCategoryList.stream().collect(Collectors.toMap(ele -> {
                String name = ele.getName();
                return name.substring(name.indexOf("\"zh_CN\": ") + 10, name.indexOf(",\"en_US\"") - 1);
            }, Function.identity()));
            List oriNameList = childCategoryList.stream().map(RotCategory::getName).map(name -> name.substring(name.indexOf("\"zh_CN\": ") + 10, name.indexOf(",\"en_US\"") - 1)).collect(Collectors.toList());
            ArrayList intersection = Lists.newArrayList((Iterable)CollUtil.intersectionDistinct(oriNameList, (Collection)cate2List2, (Collection[])new Collection[0]));
            if (intersection.equals(cate2List2)) {
                oriNameList.removeAll(cate2List2);
                removeCate2CodeList.addAll(oriNameList.stream().map(oriNameMap::get).map(RotCategory::getCode).collect(Collectors.toSet()));
                continue;
            }
            if (cate2List2.equals(oriNameList)) continue;
            countDiff2 += cate2List2.size();
            Iterator iterator = cate2List2.iterator();
            while (iterator.hasNext()) {
                String cate2NameFromFile = (String)iterator.next();
                String oriCode2 = ((RotCategory)oriNameMap.get(cate2NameFromFile)).getCode();
                String newCode2 = "cate2_" + SnowflakeIdWorker.getInstance().newId();
                cate2CodeMap.put(oriCode2, newCode2);
            }
        }
        String sqlFormat = "UPDATE rot_category SET code='%s' WHERE code ='%s';";
        String updateWordCategory = "UPDATE word_category SET word_category_id=CONCAT(`word_code`,'_','%s'),category_code='%s' WHERE category_code='%s';";
        cate2CodeMap.forEach((oriCode, newCode) -> {
            String sql = String.format(sqlFormat, newCode, oriCode);
            this.rotCategoryMapper.userDefinedSql(sql);
            sql = String.format(updateWordCategory, newCode, newCode, oriCode);
            this.rotCategoryMapper.userDefinedSql(sql);
        });
        log.info("Success update category and wordCategory");
        String sqlDeleteFormat = "DELETE FROM rot_category WHERE code ='%s';";
        for (String removeCate2Code : removeCate2CodeList) {
            String sql = String.format(sqlDeleteFormat, removeCate2Code);
            this.rotCategoryMapper.userDefinedSql(sql);
        }
        log.info("Delete category: {}", (Object)removeCate2CodeList.size());
        this.rotCategoryMapper.userDefinedSql("DELETE FROM rot_category WHERE code ='cate1_541005293208128';");
        this.rotCategoryMapper.userDefinedSql("DELETE FROM rot_category WHERE code ='cate1_535702095110720';");
        AtomicInteger count = new AtomicInteger();
        newCategoryMap.forEach((cate1, cate2List) -> {
            String codeCategory1 = "cate1_" + SnowflakeIdWorker.getInstance().newId();
            String parentCategory = "";
            String nameCategory = String.format(NAME, cate1, cate1, cate1);
            String levelCategory = "1";
            String sql = String.format(INSERT_CATEGORY, codeCategory1, parentCategory, nameCategory, levelCategory);
            this.rotCategoryMapper.userDefinedSql(sql);
            for (String cate2 : cate2List) {
                String codeCategory2 = "cate2_" + SnowflakeIdWorker.getInstance().newId();
                parentCategory = codeCategory1;
                String nameCategory2 = String.format(NAME, cate2, cate2, cate2);
                String levelCategory2 = "2";
                sql = String.format(INSERT_CATEGORY, codeCategory2, parentCategory, nameCategory2, levelCategory2);
                this.rotCategoryMapper.userDefinedSql(sql);
                count.getAndIncrement();
            }
        });
        log.info("Success add category, one: {}, two: {}", (Object)newCategoryMap.size(), (Object)count.get());
        return ResponseWrapper.ok((Object)countDiff2);
    }

    private Map<String, List<String>> collectCategoryFromExcel(MultipartFile excel) {
        InputStream inputStream = excel.getInputStream();
        ExcelReader reader = ExcelUtil.getReader((InputStream)inputStream);
        int rowCount = reader.getRowCount();
        LinkedHashMap<String, List<String>> categoryMap = new LinkedHashMap<String, List<String>>();
        int count = 0;
        for (int i = 1; i < rowCount; ++i) {
            List row = reader.readRow(i);
            if (CollectionUtils.isEmpty((Collection)row) || row.size() < 3) continue;
            String cate1 = (String)row.get(1);
            String cate2 = (String)row.get(2);
            categoryMap.putIfAbsent(cate1, Lists.newArrayList());
            ((List)categoryMap.get(cate1)).add(cate2);
            ++count;
        }
        System.out.println("\u4e00\u7ea7\u5206\u7c7b\u4e2a\u6570\uff1a" + categoryMap.size());
        System.out.println("\u4e8c\u7ea7\u5206\u7c7b\u4e2a\u6570\uff1a" + count);
        return categoryMap;
    }

    @GetMapping(value={"/word/enhance"})
    public Boolean enhancedWord() {
        this.enhancedWordScheduler.enhancedWord();
        return true;
    }

    @GetMapping(value={"/word/deviationCalculate"})
    public Boolean deviationCalculate() {
        this.enhancedWordScheduler.deviationCalculate();
        return true;
    }

    @GetMapping(value={"/word/tag/fetch"})
    public Boolean fetchTag() {
        this.fetchTagScheduler.fetchTag();
        return true;
    }

    @GetMapping(value={"/word/rule/export"})
    public Boolean exportRuleCondition(HttpServletResponse response) {
        this.wordService.exportRuleCondition(response);
        return true;
    }

    @PostMapping(value={"/word/rule/export/v2"})
    public Boolean exportRuleConditionV2(@RequestParam(value="file") MultipartFile excel, HttpServletResponse response) {
        this.wordService.exportRuleConditionV2(excel, response);
        return true;
    }
}

