/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.api.cache;

import com.digiwin.athena.appcore.cache.CacheManager;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.uibot.support.thememap.service.ThemeMapService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/cache"})
@RestController
public class CacheController {
    private static final Logger log = LoggerFactory.getLogger(CacheController.class);
    @Autowired
    CacheManager cacheManager;
    @Autowired
    ThemeMapService themeMapService;

    @GetMapping(value={"reset"})
    public ResponseEntity<?> reset() {
        this.cacheManager.batchDelete("uibot:cache:", "*");
        String result = this.themeMapService.deleteKmCache();
        log.info("delete km server cache with result:{}", (Object)result);
        return ResponseEntityWrapper.wrapperOk();
    }

    @GetMapping(value={"clear/{type}"})
    public ResponseEntity<?> clear(@PathVariable String type) {
        String serviceName = "";
        String functionName = "";
        switch (type) {
            case "metadata": {
                serviceName = "MetadataService";
                functionName = "getMetadata";
                break;
            }
            case "esp": {
                serviceName = "ESPService";
                functionName = "getTenantProductListGet";
                break;
            }
            case "tag": {
                serviceName = "ThemeMapService";
                functionName = "getMetadataTag";
                break;
            }
            case "kg": {
                serviceName = "ThemeMapService";
                functionName = "getProjectAction";
                break;
            }
        }
        this.cacheManager.batchDelete("uibot:cache:", this.getFormatKey(serviceName, functionName));
        return ResponseEntityWrapper.wrapperOk();
    }

    private String getFormatKey(String serviceName, String functionName) {
        return String.format("%s.%s(*)", serviceName, functionName);
    }
}

