/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.uibot.api.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.uibot.activity.ExecuteContext;
import com.digiwin.athena.uibot.activity.PreviewParamDTO;
import com.digiwin.athena.uibot.activity.domain.SubmitType;
import com.digiwin.athena.uibot.activity.domain.TmActivity;
import com.digiwin.athena.uibot.activity.domain.TmDataState;
import com.digiwin.athena.uibot.activity.domain.TmOperation;
import com.digiwin.athena.uibot.activity.domain.TmPage;
import com.digiwin.athena.uibot.api.BaseDataPageController;
import com.digiwin.athena.uibot.api.ConditionPageController;
import com.digiwin.athena.uibot.api.TaskPageController;
import com.digiwin.athena.uibot.component.domain.AbstractComponent;
import com.digiwin.athena.uibot.component.domain.BasicDataTableComponent;
import com.digiwin.athena.uibot.component.domain.FormAttachmentComponent;
import com.digiwin.athena.uibot.component.domain.GeneralContainComponent;
import com.digiwin.athena.uibot.component.domain.GridComponent;
import com.digiwin.athena.uibot.component.domain.LayoutContainComponent;
import com.digiwin.athena.uibot.constant.ErrorCodeEnum;
import com.digiwin.athena.uibot.designering.service.DesignerViewService;
import com.digiwin.athena.uibot.domain.DynamicForm;
import com.digiwin.athena.uibot.domain.DynamicLayout;
import com.digiwin.athena.uibot.dto.DoubleDocumentPageDefineDTO;
import com.digiwin.athena.uibot.support.thememap.domain.MetadataDataDTO;
import com.digiwin.athena.uibot.util.ExceptionMessageUtils;
import com.digiwin.athena.uibot.util.GridComponentUtil;
import com.digiwin.athena.uibot.util.ThreadLocalUtil;
import com.digiwin.athena.uibot.util.UiBotUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DesignerViewServiceImpl
implements DesignerViewService {
    private static final Logger log = LoggerFactory.getLogger(DesignerViewServiceImpl.class);
    @Resource
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private HttpServletRequest httpServletRequest;
    @Resource
    private TaskPageController taskPageController;
    @Resource
    private BaseDataPageController baseDataPageController;
    @Resource
    private ConditionPageController conditionPageController;
    @Resource
    private ExceptionMessageUtils exceptionMessageUtils;
    private static final List<String> RESERVE_OPERATION_TYPE = Lists.newArrayList((Object[])new String[]{"add", "openpage"});
    private static final List<String> RESERVE_OPERATION_OPERATE = Lists.newArrayList((Object[])new String[]{"add-row", "openpage"});
    private static final List<String> REMOVE_ROW_OPERATION_TYPE = Lists.newArrayList((Object[])new String[]{"openpage"});

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object pagePreview(HttpServletRequest request, String key) {
        log.info("=== Preview begin: {}", (Object)key);
        long start = System.currentTimeMillis();
        try {
            PreviewParamDTO previewParam = this.parsePreviewParam(key);
            this.formPreProcessor(request, previewParam);
            Object formObject = this.dispatch();
            Object object = this.formPostProcessor(formObject);
            return object;
        }
        finally {
            ThreadLocalUtil.clearContext();
            log.info("=== Preview finish, cost: {} ms", (Object)(System.currentTimeMillis() - start));
        }
    }

    private void formPreProcessor(HttpServletRequest request, PreviewParamDTO previewParam) {
        this.checkPreviewParam(previewParam);
        this.resetPreviewParam(previewParam);
        ExecuteContext executeContext = this.mockAndSetAuthoredUser(request);
        executeContext.setPreviewParam(previewParam);
        ThreadLocalUtil.setContext((Object)executeContext);
    }

    private Object formPostProcessor(Object formObject) {
        return this.resetDynamicFormParam(formObject);
    }

    private void resetPreviewParam(PreviewParamDTO previewParam) {
        TmActivity tmActivity = previewParam.getTaskDefinition();
        if (tmActivity == null || tmActivity.getPages() == null) {
            return;
        }
        TmPage pages = tmActivity.getPages();
        this.resetOperations(pages.getOperations());
        this.resetDataStates(pages);
    }

    private void resetDataStates(TmPage pages) {
        if (CollectionUtils.isEmpty((Collection)pages.getDataStates())) {
            return;
        }
        List dataStates = pages.getDataStates();
        TmDataState firstDataState = (TmDataState)CollUtil.getFirst((Iterable)dataStates);
        if (firstDataState == null) {
            return;
        }
        this.resetOperations(firstDataState.getOperations());
        pages.setDataStates((List)Lists.newArrayList((Object[])new TmDataState[]{firstDataState}));
    }

    private void resetOperations(List<TmOperation> operations) {
        Optional.ofNullable(operations).orElse(Lists.newArrayList()).removeIf(operation -> {
            if (Objects.isNull(operation)) {
                return true;
            }
            String mode = operation.getMode();
            String operate = operation.getOperate();
            String type = operation.getType();
            boolean isAllMode = "all".equals(mode);
            boolean isRowMode = "row".equals(mode);
            boolean isAllModeRemove = isAllMode && !RESERVE_OPERATION_TYPE.contains(type) && !RESERVE_OPERATION_OPERATE.contains(operate);
            boolean isRowModeRemove = isRowMode && REMOVE_ROW_OPERATION_TYPE.contains(type);
            return isAllModeRemove || isRowModeRemove;
        });
    }

    private Object resetDynamicFormParam(Object formObject) {
        List layoutList;
        if (formObject instanceof DynamicLayout) {
            DynamicLayout dynamicLayout = (DynamicLayout)formObject;
            layoutList = dynamicLayout.getLayout();
        } else if (formObject instanceof DynamicForm) {
            DynamicForm dynamicForm = (DynamicForm)formObject;
            layoutList = dynamicForm.getLayout();
            dynamicForm.setActions((List)Lists.newArrayList());
        } else {
            return formObject;
        }
        this.resetLayoutParam(layoutList);
        return formObject;
    }

    private void resetLayoutParam(List<AbstractComponent> layoutList) {
        if (CollectionUtils.isEmpty(layoutList)) {
            return;
        }
        for (AbstractComponent layout : layoutList) {
            if (layout instanceof LayoutContainComponent) {
                LayoutContainComponent layoutContainComponent = (LayoutContainComponent)layout;
                List subComponents = layoutContainComponent.getSubComponents();
                for (GeneralContainComponent subComponent : subComponents) {
                    this.resetLayoutParam(subComponent.getGroup());
                }
                continue;
            }
            if (!(layout instanceof GridComponent)) continue;
            GridComponent gridComponent = (GridComponent)layout;
            gridComponent.setSaveColumnsWidth(Boolean.FALSE);
            gridComponent.setDisabledUserDefined(Boolean.TRUE);
            gridComponent.setSetting(GridComponentUtil.buildHideDefaultToolbar());
            gridComponent.setFilterMode("value");
            if (layout instanceof BasicDataTableComponent) {
                BasicDataTableComponent basicDataTableComponent = (BasicDataTableComponent)layout;
                basicDataTableComponent.setActions((List)Lists.newArrayList());
            }
            this.attachmentComponentHandle(gridComponent);
        }
    }

    private void attachmentComponentHandle(GridComponent gridComponent) {
        List columnDefs = gridComponent.getColumnDefs();
        Optional.ofNullable(columnDefs).orElse(Lists.newArrayList()).forEach(columnDef -> Optional.ofNullable(columnDef.getColumns()).orElse(Lists.newArrayList()).forEach(column -> {
            if ("FILE_UPLOAD".equals(column.getType())) {
                column.setDisabled(Boolean.valueOf(true));
                column.setEditable(Boolean.valueOf(false));
                this.resetAttachmentComponentParam((AbstractComponent)column);
            }
        }));
    }

    private void resetAttachmentComponentParam(AbstractComponent column) {
        if (column instanceof FormAttachmentComponent) {
            FormAttachmentComponent attachmentComponent = (FormAttachmentComponent)column;
            Map attribute = attachmentComponent.getAttribute();
            attribute.put("editable", false);
            attribute.put("readEnable", false);
            attribute.put("deleteEnable", false);
            attribute.put("uploadEnable", false);
            attribute.put("disableAam", Boolean.TRUE);
            attribute.put("type", "OUTER");
        }
    }

    private ExecuteContext mockAndSetAuthoredUser(HttpServletRequest request) {
        AuthoredUser authoredUser = new AuthoredUser();
        authoredUser.setTenantId("previewTenantId");
        authoredUser.setTenantName("previewTenantName");
        authoredUser.setUserId("previewUserId");
        authoredUser.setUserName("previewUserName");
        AppAuthContextHolder.getContext().setAuthoredUser(authoredUser);
        request.setAttribute("digi-middleware-auth-user-data", (Object)authoredUser);
        return ExecuteContext.createByHttpRequest((HttpServletRequest)request);
    }

    private PreviewParamDTO parsePreviewParam(String key) {
        String jsonStr;
        ArrayList demoFileNameList = Lists.newArrayList((Object[])new String[]{"previewParamDTO", "previewParamDTO_basicData", "previewParamDTO_doubleBrowsePage", "previewParamDTO_doubleEditPage", "previewParamDTO_reportCondition"});
        if (demoFileNameList.contains(key) || key.contains("previewParam")) {
            String filePath = StrUtil.format((CharSequence)"mock/{}.json", (Object[])new Object[]{key});
            jsonStr = ResourceUtil.readUtf8Str((String)filePath);
            JSONObject jsonObject = (JSONObject)JsonUtils.jsonToObject((String)jsonStr, JSONObject.class);
            if (jsonObject.containsKey((Object)"data")) {
                jsonStr = jsonObject.getString("data");
            }
        } else if (BooleanUtils.isTrue((Boolean)this.redisTemplate.hasKey((Object)key))) {
            jsonStr = (String)this.redisTemplate.opsForValue().get((Object)key);
        } else {
            log.warn("=== Preview key not exist: {}", (Object)key);
            return null;
        }
        log.debug("\n=== Preview param:\nkey: {},\nvalue: {}", (Object)key, (Object)jsonStr);
        if (JSONUtil.isTypeJSON((String)jsonStr)) {
            return (PreviewParamDTO)JsonUtils.jsonToObject((String)jsonStr, PreviewParamDTO.class);
        }
        return null;
    }

    private void checkPreviewParam(PreviewParamDTO previewParamDTO) {
        if (previewParamDTO == null) {
            String errorMessage = this.exceptionMessageUtils.getMessageWithDefaultLocale(ErrorCodeEnum.PREVIEW_DATA_EMPTY.getErrCode());
            throw BusinessException.create((String)ErrorCodeEnum.PREVIEW_DATA_EMPTY.getErrCode(), (String)errorMessage);
        }
        TmActivity taskDefinition = previewParamDTO.getTaskDefinition();
        if (taskDefinition == null) {
            String errorMessage = this.exceptionMessageUtils.getMessageWithDefaultLocale(ErrorCodeEnum.PREVIEW_DATA_TASK_DEF_EMPTY.getErrCode());
            throw BusinessException.create((String)ErrorCodeEnum.PREVIEW_DATA_TASK_DEF_EMPTY.getErrCode(), (String)errorMessage);
        }
        String activityId = taskDefinition.getActivityId();
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            String errorMessage = this.exceptionMessageUtils.getMessageWithDefaultLocale(ErrorCodeEnum.PREVIEW_DATA_TASK_ID_EMPTY.getErrCode());
            throw BusinessException.create((String)ErrorCodeEnum.PREVIEW_DATA_TASK_ID_EMPTY.getErrCode(), (String)errorMessage);
        }
        MetadataDataDTO metadata = previewParamDTO.getMetadata();
        if (metadata == null) {
            String errorMessage = this.exceptionMessageUtils.getMessageWithDefaultLocale(ErrorCodeEnum.PREVIEW_DATA_METADATA_EMPTY.getErrCode());
            throw BusinessException.create((String)ErrorCodeEnum.PREVIEW_DATA_METADATA_EMPTY.getErrCode(), (String)errorMessage);
        }
    }

    private Object dispatch() {
        ResponseEntity<?> responseEntity;
        ExecuteContext executeContext = (ExecuteContext)ThreadLocalUtil.getContext();
        PreviewParamDTO previewParam = executeContext.getPreviewParam();
        String pageCode = previewParam.getPageCode();
        pageCode = pageCode == null ? "" : pageCode;
        TmActivity tmActivity = UiBotUtils.getPreviewParam().getTaskDefinition();
        String previewActivityId = tmActivity.getActivityId();
        String category = tmActivity.getCategory();
        log.info("=== Preview dispatch, pattern: {}, category: {}, pageCode: {}", new Object[]{tmActivity.getPattern(), category, pageCode});
        if (category != null && category.contains("TREEDATA")) {
            responseEntity = this.baseDataPageController.createTreeDataDocBrowsePageTemplate(this.httpServletRequest, previewActivityId);
        } else {
            switch (pageCode) {
                case "basic-data": {
                    responseEntity = this.baseDataPageController.basicDataTaskShow(this.httpServletRequest, previewActivityId);
                    break;
                }
                case "browse-page": {
                    responseEntity = this.baseDataPageController.createDoubleDocBrowsePageTemplate(this.httpServletRequest, previewActivityId);
                    break;
                }
                case "edit-page": {
                    DoubleDocumentPageDefineDTO doubleDocumentPageDefineDTO = this.buildDoubleDocumentPageDefineDTO();
                    responseEntity = this.baseDataPageController.createDoubleDocDetailPageTemplate(this.httpServletRequest, doubleDocumentPageDefineDTO);
                    break;
                }
                case "condition-detail": {
                    responseEntity = this.conditionPageController.conditionPageShow(this.httpServletRequest, previewActivityId);
                    break;
                }
                default: {
                    responseEntity = this.taskPageController.templateActivityShow(this.httpServletRequest, "previewTaskId", previewActivityId, "previewBacklogId", false, false, AppAuthContextHolder.getContext().getAuthoredUser());
                }
            }
        }
        return ((BaseResultDTO)responseEntity.getBody()).getResponse();
    }

    private DoubleDocumentPageDefineDTO buildDoubleDocumentPageDefineDTO() {
        return DoubleDocumentPageDefineDTO.builder().defaultShow(Boolean.FALSE).executeContext(ExecuteContext.builder().build()).parameter(Maps.newHashMap()).submitType(SubmitType.builder().isBatch(Boolean.FALSE).build()).build();
    }
}

