/*
 * Decompiled with CFR 0.152.
 */
package digiwin.chartsdk.utils;

import digiwin.chartsdk.beans.sdk.chart.ChartBarSeries;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.ChartBaseSeries;
import digiwin.chartsdk.beans.sdk.chart.ChartCategoryAxis;
import digiwin.chartsdk.beans.sdk.chart.ChartFormat;
import digiwin.chartsdk.beans.sdk.chart.ChartLegend;
import digiwin.chartsdk.beans.sdk.chart.ChartLineSeries;
import digiwin.chartsdk.beans.sdk.chart.ChartTooltip;
import digiwin.chartsdk.beans.sdk.chart.ChartValue;
import digiwin.chartsdk.beans.sdk.chart.Point;
import digiwin.chartsdk.beans.sdk.chart.Value;
import digiwin.chartsdk.utils.ChartGraphBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.icepear.echarts.Option;
import org.icepear.echarts.components.coord.cartesian.CategoryAxis;
import org.icepear.echarts.origin.component.legend.LegendOption;
import org.icepear.echarts.origin.component.title.TitleOption;
import org.icepear.echarts.origin.component.tooltip.TooltipOption;
import org.icepear.echarts.origin.coord.cartesian.AxisOption;
import org.icepear.echarts.origin.util.SeriesOption;
import org.springframework.stereotype.Component;

@Component
public class ChartDoubleShaft
extends ChartGraphBase {
    public static Option getChart(ChartBase chartBase) {
        Option doubleShaft = new Option();
        doubleShaft.setTitle((TitleOption)ChartGraphBase.getTitle());
        ChartLegend legend = ChartGraphBase.getLegend();
        ArrayList legendList = Lists.newArrayList();
        ArrayList legendDescriptionList = Lists.newArrayList();
        ChartTooltip tooltip = ChartGraphBase.getTooltip();
        doubleShaft.setTooltip((TooltipOption)tooltip);
        ArrayList axisList = Lists.newArrayList();
        ArrayList xAxis = Lists.newArrayList();
        ArrayList yxisList = Lists.newArrayList();
        doubleShaft.setYAxis((Object)yxisList);
        ArrayList series = Lists.newArrayList();
        doubleShaft.setSeries(series.toArray(new SeriesOption[series.size()]));
        ChartDoubleShaft.buildChartValue(chartBase, legendList, legendDescriptionList, yxisList, xAxis, series, tooltip);
        for (int i = 0; i < xAxis.size(); ++i) {
            CategoryAxis axis = new CategoryAxis();
            axis.setData((Object[])((List)xAxis.get(i)).toArray(new String[((List)xAxis.get(i)).size()]));
            axisList.add(axis);
        }
        doubleShaft.setXAxis((AxisOption[])axisList.toArray(new CategoryAxis[axisList.size()]));
        doubleShaft.setSeries(series.toArray(new SeriesOption[series.size()]));
        String[] legendArray = legendList.toArray(new String[legendList.size()]);
        legend.setData(legendArray);
        legend.setDescription(legendDescriptionList.toArray(new String[legendDescriptionList.size()]));
        doubleShaft.setLegend((LegendOption)legend);
        return doubleShaft;
    }

    private static void buildChartValue(ChartBase chartBase, List<String> legendList, List<String> legendDescriptionList, List<CategoryAxis> yxisList, List<List<String>> xAxis, List<SeriesOption> series, ChartTooltip tooltip) {
        for (int i = 0; i < chartBase.getChartBaseSeries().size(); ++i) {
            ChartBaseSeries chartBaseSeries = chartBase.getChartBaseSeries().get(i);
            List<Point> points = chartBaseSeries.getPoints();
            List<Value> values = chartBaseSeries.getValues();
            List measureTitle = chartBaseSeries.getValues().stream().map(Value::getTitle).collect(Collectors.toList());
            List descriptionTitle = chartBaseSeries.getValues().stream().filter(x -> StringUtils.isNotEmpty((CharSequence)x.getDescription())).map(Value::getDescription).collect(Collectors.toList());
            legendList.addAll(measureTitle);
            if (CollectionUtils.isNotEmpty(descriptionTitle)) {
                legendDescriptionList.addAll(descriptionTitle);
            }
            ChartCategoryAxis yAxis = new ChartCategoryAxis();
            yAxis.setType("value");
            yxisList.add(yAxis);
            ArrayList pointNameList = new ArrayList();
            for (Point point : points) {
                ArrayList<String> names = new ArrayList<String>();
                for (Map<String, Object> map : chartBase.getDatas()) {
                    String date = String.valueOf(map.get(point.getName()));
                    names.add(date);
                }
                pointNameList.add(names);
            }
            if (CollectionUtils.isEmpty(xAxis)) {
                xAxis.addAll(pointNameList);
            }
            ArrayList<ChartValue> valueNameList = new ArrayList<ChartValue>();
            for (Value valueField : values) {
                ArrayList<String> names = new ArrayList<String>();
                ChartValue chartValue = new ChartValue();
                chartValue.setType(valueField.getType());
                chartValue.setTitle(valueField.getTitle());
                chartValue.setPercent(valueField.getPercent());
                chartValue.setDecimal(valueField.getDecimal());
                chartValue.setExtendInfo(valueField.getExtendInfo());
                for (Map<String, Object> map : chartBase.getDatas()) {
                    String date = String.valueOf(map.get(valueField.getName()));
                    names.add(date);
                }
                chartValue.setValues(names);
                valueNameList.add(chartValue);
            }
            ChartFormat chartFormat = new ChartFormat();
            for (ChartValue nameValue : valueNameList) {
                chartFormat.setPercent(nameValue.getPercent());
                chartFormat.setDecimal(nameValue.getDecimal());
                switch (nameValue.getType()) {
                    case "line": {
                        ChartLineSeries lineSeries = new ChartLineSeries();
                        lineSeries.setSmooth(true);
                        lineSeries.setName(nameValue.getTitle());
                        lineSeries.setYAxisIndex(i);
                        lineSeries.setData(nameValue.getValues().toArray(new String[valueNameList.size()]));
                        lineSeries.setFormat(chartFormat);
                        lineSeries.setExtendInfo(nameValue.getExtendInfo());
                        series.add((SeriesOption)lineSeries);
                        break;
                    }
                    case "bar": {
                        ChartBarSeries barSeries = new ChartBarSeries();
                        barSeries.setName(nameValue.getTitle());
                        barSeries.setYAxisIndex(i);
                        barSeries.setData(nameValue.getValues().toArray(new String[valueNameList.size()]));
                        barSeries.setFormat(chartFormat);
                        barSeries.setExtendInfo(nameValue.getExtendInfo());
                        series.add((SeriesOption)barSeries);
                        break;
                    }
                }
            }
            yAxis.setFormat(chartFormat);
            tooltip.setFormat(chartFormat);
        }
    }
}

