/*
 * Decompiled with CFR 0.152.
 */
package digiwin.chartsdk.utils;

import com.google.common.collect.Maps;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.ChartBaseSeries;
import digiwin.chartsdk.beans.sdk.chart.ChartFormat;
import digiwin.chartsdk.beans.sdk.chart.ChartPieSeries;
import digiwin.chartsdk.beans.sdk.chart.Point;
import digiwin.chartsdk.beans.sdk.chart.Value;
import digiwin.chartsdk.utils.ChartGraphBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.icepear.echarts.Chart;
import org.icepear.echarts.Pie;
import org.icepear.echarts.components.title.Title;
import org.icepear.echarts.components.tooltip.Tooltip;
import org.icepear.echarts.origin.util.SeriesOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ChartPie
extends ChartGraphBase {
    private static final Logger log = LoggerFactory.getLogger(ChartPie.class);

    public static Chart getChart(ChartBase chartBase, ChartBaseSeries chartBaseSeries) {
        List<Point> points = chartBaseSeries.getPoints();
        List<Value> values = chartBaseSeries.getValues();
        Title title = new Title();
        title.setText("");
        title.setLeft("left");
        return ChartPie.getPie(chartBase, points, values);
    }

    private static Pie getPie(ChartBase chartBase, List<Point> points, List<Value> values) {
        Tooltip tooltip = new Tooltip();
        tooltip.setTrigger("item");
        tooltip.setFormatter("{a} <br/>{b}: {c} ({d}%)");
        Title title = new Title();
        title.setText("");
        title.setLeft("left");
        Pie pieChart = (Pie)((Pie)new Pie().setTitle(title)).setTooltip(tooltip);
        Point point = new Point();
        if (CollectionUtils.isNotEmpty(points)) {
            point = points.get(0);
        }
        Value value = new Value();
        if (CollectionUtils.isNotEmpty(values)) {
            value = values.get(0);
        }
        if (CollectionUtils.isNotEmpty(points) && CollectionUtils.isNotEmpty(values)) {
            HashMap<Object, Double> valuesSeries = new HashMap<Object, Double>();
            for (Map<String, Object> data : chartBase.getDatas()) {
                Object showName = data.get(point.getName());
                Object showValue = data.get(value.getName());
                Double purchaseSum = null;
                try {
                    purchaseSum = (Double)showValue;
                }
                catch (Exception e) {
                    log.info("\u7ed3\u679c\uff1a" + showValue + "\uff0c\u65e0\u6cd5\u5f3a\u8f6c\u4e3aDouble");
                    Integer integerValue = (Integer)showValue;
                    purchaseSum = integerValue.doubleValue();
                }
                if (valuesSeries.containsKey(showName)) {
                    double currentSum = (Double)valuesSeries.get(showName);
                    valuesSeries.put(showName, currentSum + purchaseSum);
                    continue;
                }
                valuesSeries.put(showName, purchaseSum);
            }
            List valuesSeriesList = valuesSeries.entrySet().stream().map(x -> {
                HashMap series = Maps.newHashMap();
                series.put("name", x.getKey());
                series.put("value", x.getValue());
                return series;
            }).collect(Collectors.toList());
            ChartFormat chartFormat = new ChartFormat();
            chartFormat.setDecimal(value.getDecimal());
            chartFormat.setPercent(value.getPercent());
            ChartPieSeries pieSeries = new ChartPieSeries();
            pieSeries.setFormat(chartFormat);
            pieSeries.setData(valuesSeriesList).setRadius(new String[]{"30%", "70%"});
            pieSeries.setExtendInfo(value.getExtendInfo());
            pieChart.addSeries((SeriesOption)pieSeries);
        }
        return pieChart;
    }
}

