/*
 * Decompiled with CFR 0.152.
 */
package digiwin.chartsdk.utils;

import com.google.gson.Gson;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.ChartBaseSeries;
import digiwin.chartsdk.utils.ChartBar;
import digiwin.chartsdk.utils.ChartDoubleShaft;
import digiwin.chartsdk.utils.ChartLine;
import digiwin.chartsdk.utils.ChartPie;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.icepear.echarts.Option;
import org.icepear.echarts.render.Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class ChartUtil {
    private static final Logger log = LoggerFactory.getLogger(ChartUtil.class);

    public static digiwin.chartsdk.beans.sdk.chart.Option getOption(ChartBase chartBase) {
        if (Objects.isNull(chartBase)) {
            return null;
        }
        if (CollectionUtils.isEmpty(chartBase.getChartBaseSeries())) {
            return null;
        }
        String jsonStr = "";
        if (chartBase.getChartBaseSeries().size() == 1) {
            ChartBaseSeries chartBaseSeries = chartBase.getChartBaseSeries().get(0);
            switch (chartBaseSeries.getType()) {
                case "line": {
                    Engine engine = new Engine();
                    jsonStr = engine.renderJsonOption(ChartLine.getChart(chartBase, chartBaseSeries));
                    break;
                }
                case "bar": {
                    Engine engineBar = new Engine();
                    jsonStr = engineBar.renderJsonOption(ChartBar.getChart(chartBase, chartBaseSeries));
                    break;
                }
                case "pie": {
                    Engine enginePie = new Engine();
                    jsonStr = enginePie.renderJsonOption(ChartPie.getChart(chartBase, chartBaseSeries));
                    break;
                }
            }
        } else {
            Engine engine = new Engine();
            jsonStr = engine.renderJsonOption(ChartDoubleShaft.getChart(chartBase));
        }
        Option option = (Option)new Gson().fromJson(jsonStr, Option.class);
        digiwin.chartsdk.beans.sdk.chart.Option option1 = new digiwin.chartsdk.beans.sdk.chart.Option();
        BeanUtils.copyProperties((Object)option, (Object)option1);
        return option1;
    }
}

