/*
 * Decompiled with CFR 0.152.
 */
package digiwin.chartsdk.utils;

import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.ChartBaseSeries;
import digiwin.chartsdk.beans.sdk.chart.ChartFormat;
import digiwin.chartsdk.beans.sdk.chart.ChartLegend;
import digiwin.chartsdk.beans.sdk.chart.ChartLineSeries;
import digiwin.chartsdk.beans.sdk.chart.ChartTooltip;
import digiwin.chartsdk.beans.sdk.chart.ChartValue;
import digiwin.chartsdk.beans.sdk.chart.ChartValueAxis;
import digiwin.chartsdk.beans.sdk.chart.Point;
import digiwin.chartsdk.beans.sdk.chart.Value;
import digiwin.chartsdk.utils.ChartGraphBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.icepear.echarts.Chart;
import org.icepear.echarts.Line;
import org.icepear.echarts.components.legend.Legend;
import org.icepear.echarts.components.marker.MarkLine;
import org.icepear.echarts.components.marker.MarkLine1DDataItem;
import org.icepear.echarts.components.title.Title;
import org.icepear.echarts.components.tooltip.Tooltip;
import org.icepear.echarts.origin.component.marker.MarkLineDataItemOption;
import org.icepear.echarts.origin.component.marker.MarkLineOption;
import org.icepear.echarts.origin.coord.cartesian.AxisOption;
import org.icepear.echarts.origin.util.SeriesOption;
import org.springframework.stereotype.Component;

@Component
public class ChartLine
extends ChartGraphBase {
    public static Chart getChart(ChartBase chartBase, ChartBaseSeries chartBaseSeries) {
        List<Point> points = chartBaseSeries.getPoints();
        List<Value> values = chartBaseSeries.getValues();
        ChartLegend legend = ChartGraphBase.getLegend();
        List<String> legendList = chartBaseSeries.getValues().stream().map(Value::getTitle).collect(Collectors.toList());
        ArrayList legendDescription = new ArrayList();
        chartBaseSeries.getValues().stream().forEach(value -> {
            if (StringUtils.isNotEmpty((CharSequence)value.getDescription())) {
                legendDescription.add(value.getDescription());
            } else {
                legendDescription.add(null);
            }
        });
        String[] legendArray = legendList.toArray(new String[legendList.size()]);
        legend.setData(legendArray);
        if (CollectionUtils.isNotEmpty(legendDescription)) {
            legend.setDescription(legendDescription.toArray(new String[legendDescription.size()]));
        }
        Title title = new Title();
        title.setText("");
        title.setLeft("left");
        ChartTooltip tooltip = ChartGraphBase.getTooltip();
        ArrayList<List<String>> pointNameList = new ArrayList<List<String>>();
        for (Point pointField : points) {
            ArrayList<String> names = new ArrayList<String>();
            for (Map<String, Object> map : chartBase.getDatas()) {
                String date = String.valueOf(map.get(pointField.getName()));
                names.add(date);
            }
            pointNameList.add(names);
        }
        ArrayList<ChartValue> valueNameList = new ArrayList<ChartValue>();
        for (Value valueField : values) {
            ChartValue chartValue = new ChartValue();
            ArrayList<String> names = new ArrayList<String>();
            for (Map<String, Object> map : chartBase.getDatas()) {
                String date = String.valueOf(map.get(valueField.getName()));
                names.add(date);
            }
            chartValue.setValues(names);
            chartValue.setDecimal(valueField.getDecimal());
            chartValue.setPercent(valueField.getPercent());
            chartValue.setDecimalRule(valueField.getDecimalRule());
            chartValue.setUnit(valueField.getUnit());
            chartValue.setMarkLine(valueField.getMarkLine());
            chartValue.setExtendInfo(valueField.getExtendInfo());
            valueNameList.add(chartValue);
        }
        return ChartLine.getLine(legend, title, tooltip, pointNameList, valueNameList, legendList);
    }

    private static Line getLine(Legend legend, Title title, ChartTooltip tooltip, List<List<String>> pointNameList, List<ChartValue> valueNameList, List<String> legendList) {
        int i;
        Line lineChart = (Line)((Line)((Line)new Line().setLegend(legend)).setTitle(title)).setTooltip((Tooltip)tooltip);
        ChartFormat format = new ChartFormat();
        for (i = 0; i < pointNameList.size(); ++i) {
            lineChart.addXAxis(pointNameList.get(i).toArray(new String[pointNameList.get(i).size()]));
        }
        for (i = 0; i < valueNameList.size(); ++i) {
            ChartValue chartValue = valueNameList.get(i);
            ChartLineSeries lineSeries = new ChartLineSeries();
            lineSeries.setSmooth(true);
            lineSeries.setName(legendList.get(i));
            lineSeries.setData(chartValue.getValues().toArray(new String[chartValue.getValues().size()]));
            format.setDecimal(chartValue.getDecimal());
            format.setPercent(chartValue.getPercent());
            format.setDecimalRule(chartValue.getDecimalRule());
            format.setUnit(chartValue.getUnit());
            lineSeries.setFormat(format);
            lineSeries.setExtendInfo(chartValue.getExtendInfo());
            if (CollectionUtils.isNotEmpty(chartValue.getMarkLine())) {
                MarkLine markLine = new MarkLine();
                ArrayList markLine1DDataItemList = new ArrayList();
                chartValue.getMarkLine().stream().forEach(mark -> {
                    MarkLine1DDataItem markLine1DDataItem = new MarkLine1DDataItem();
                    markLine1DDataItem.setType(mark);
                    markLine1DDataItemList.add(markLine1DDataItem);
                });
                markLine.setData(markLine1DDataItemList.toArray(new MarkLineDataItemOption[markLine1DDataItemList.size()]));
                lineSeries.setMarkLine((MarkLineOption)markLine);
            }
            lineChart.addSeries((SeriesOption)lineSeries);
        }
        ChartValueAxis yAxis = new ChartValueAxis();
        yAxis.setFormat(format);
        lineChart.addYAxis((AxisOption)yAxis);
        tooltip.setFormat(format);
        return lineChart;
    }
}

