/*
 * Decompiled with CFR 0.152.
 */
package digiwin.chartsdk.utils;

import com.google.gson.Gson;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.utils.ChartBar;
import digiwin.chartsdk.utils.ChartBubble;
import digiwin.chartsdk.utils.ChartDoubleShaft;
import digiwin.chartsdk.utils.ChartLine;
import digiwin.chartsdk.utils.ChartLineBar;
import digiwin.chartsdk.utils.ChartPie;
import digiwin.chartsdk.utils.ChartScatter;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.icepear.echarts.Option;
import org.icepear.echarts.render.Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class ChartUtil {
    private static final Logger log = LoggerFactory.getLogger(ChartUtil.class);

    public static digiwin.chartsdk.beans.sdk.chart.Option getOption(ChartBase chartBase) {
        if (Objects.isNull(chartBase)) {
            return null;
        }
        if (CollectionUtils.isEmpty(chartBase.getChartBaseSeries())) {
            return null;
        }
        String jsonStr = "";
        switch (chartBase.getShowType()) {
            case "line": {
                Engine engine = new Engine();
                jsonStr = engine.renderJsonOption(ChartLine.getChart(chartBase, chartBase.getChartBaseSeries().get(0)));
                break;
            }
            case "bar": {
                Engine engineBar = new Engine();
                jsonStr = engineBar.renderJsonOption(ChartBar.getChart(chartBase, chartBase.getChartBaseSeries().get(0)));
                break;
            }
            case "pie": {
                Engine enginePie = new Engine();
                jsonStr = enginePie.renderJsonOption(ChartPie.getChart(chartBase, chartBase.getChartBaseSeries().get(0)));
                break;
            }
            case "mixed": {
                Engine engineMix = new Engine();
                jsonStr = engineMix.renderJsonOption(ChartDoubleShaft.getChart(chartBase));
                break;
            }
            case "line-bar": {
                Engine engineLineBar = new Engine();
                jsonStr = engineLineBar.renderJsonOption(ChartLineBar.getChart(chartBase, chartBase.getChartBaseSeries().get(0)));
                break;
            }
            case "scatter": {
                Engine engineScatter = new Engine();
                jsonStr = engineScatter.renderJsonOption(ChartScatter.getChart(chartBase, chartBase.getChartBaseSeries().get(0)));
                break;
            }
            case "bubble": {
                Engine engineBubble = new Engine();
                jsonStr = engineBubble.renderJsonOption(ChartBubble.getChart(chartBase, chartBase.getChartBaseSeries().get(0)));
                break;
            }
        }
        Option option = (Option)new Gson().fromJson(jsonStr, Option.class);
        digiwin.chartsdk.beans.sdk.chart.Option option1 = new digiwin.chartsdk.beans.sdk.chart.Option();
        if (StringUtils.isNotEmpty((CharSequence)jsonStr)) {
            BeanUtils.copyProperties((Object)option, (Object)option1);
        }
        return option1;
    }
}

