/*
 * Decompiled with CFR 0.152.
 */
package digiwin.chartsdk.utils;

import com.google.gson.Gson;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.Point;
import digiwin.chartsdk.beans.sdk.chart.Value;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.icepear.echarts.Bar;
import org.icepear.echarts.Chart;
import org.icepear.echarts.Line;
import org.icepear.echarts.Option;
import org.icepear.echarts.Pie;
import org.icepear.echarts.charts.bar.BarSeries;
import org.icepear.echarts.charts.line.LineSeries;
import org.icepear.echarts.charts.pie.PieSeries;
import org.icepear.echarts.components.legend.Legend;
import org.icepear.echarts.components.title.Title;
import org.icepear.echarts.components.tooltip.Tooltip;
import org.icepear.echarts.origin.util.SeriesOption;
import org.icepear.echarts.render.Engine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class ChartUtil {
    private static final Logger log = LoggerFactory.getLogger(ChartUtil.class);

    /*
     * WARNING - void declaration
     */
    public static digiwin.chartsdk.beans.sdk.chart.Option getOption(ChartBase chartBase) {
        void var10_16;
        if (Objects.isNull(chartBase)) {
            return null;
        }
        List<Point> points = chartBase.getPoints();
        List<Value> values = chartBase.getValues();
        List<String> legendList = values.stream().map(Value::getTitle).collect(Collectors.toList());
        String[] legendArray = legendList.toArray(new String[legendList.size()]);
        Legend legend = new Legend();
        legend.setData(legendArray);
        legend.setOrient("horizontal");
        legend.setTop("bottom");
        Title title = new Title();
        title.setText("");
        title.setLeft("left");
        Tooltip tooltip = new Tooltip();
        tooltip.setTrigger("axis");
        ArrayList pointNameList = new ArrayList();
        for (Point point : points) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (Map<String, Object> map : chartBase.getDatas()) {
                String string = (String)map.get(point.getName());
                arrayList.add(string);
            }
            pointNameList.add(arrayList);
        }
        ArrayList valueNameList = new ArrayList();
        for (Value value : values) {
            ArrayList<String> names = new ArrayList<String>();
            for (Map<String, Object> map : chartBase.getDatas()) {
                String date = String.valueOf(map.get(value.getName()));
                names.add(date);
            }
            valueNameList.add(names);
        }
        String string = "";
        switch (chartBase.getType()) {
            case "line": {
                void var14_33;
                Line line = (Line)((Line)((Line)((Line)new Line().addYAxis()).setLegend(legend)).setTitle(title)).setTooltip(tooltip);
                boolean bl = false;
                while (var14_33 < pointNameList.size()) {
                    line.addXAxis(((List)pointNameList.get((int)var14_33)).toArray(new String[((List)pointNameList.get((int)var14_33)).size()]));
                    ++var14_33;
                }
                if (CollectionUtils.isNotEmpty(valueNameList) && valueNameList.size() == 1) {
                    LineSeries lineSeries = new LineSeries();
                    lineSeries.setSmooth(Boolean.valueOf(true));
                    lineSeries.setName((String)legendList.get(0));
                    lineSeries.setData((Object[])((List)valueNameList.get(0)).toArray(new String[((List)valueNameList.get(0)).size()]));
                    line.addSeries((SeriesOption)lineSeries);
                } else {
                    void var14_36;
                    boolean bl2 = false;
                    while (var14_36 < valueNameList.size()) {
                        LineSeries lineSeries = new LineSeries();
                        lineSeries.setSmooth(Boolean.valueOf(true));
                        lineSeries.setName((String)legendList.get((int)var14_36));
                        lineSeries.setData((Object[])((List)valueNameList.get((int)var14_36)).toArray(new String[((List)valueNameList.get((int)var14_36)).size()]));
                        line.addSeries((SeriesOption)lineSeries);
                        ++var14_36;
                    }
                }
                Engine engine = new Engine();
                String string2 = engine.renderJsonOption((Chart)line);
                break;
            }
            case "bar": {
                int i;
                Bar barChart = (Bar)((Bar)((Bar)((Bar)new Bar().addYAxis()).setLegend(legend)).setTitle(title)).setTooltip(tooltip);
                for (i = 0; i < pointNameList.size(); ++i) {
                    barChart.addXAxis(((List)pointNameList.get(i)).toArray(new String[((List)pointNameList.get(i)).size()]));
                }
                if (CollectionUtils.isNotEmpty(valueNameList) && valueNameList.size() == 1) {
                    BarSeries barSeries = new BarSeries();
                    barSeries.setName((String)legendList.get(0));
                    barSeries.setData(((List)valueNameList.get(0)).toArray(new String[((List)valueNameList.get(0)).size()]));
                    barChart.addSeries((SeriesOption)barSeries);
                } else {
                    for (i = 0; i < valueNameList.size(); ++i) {
                        BarSeries barSeries = new BarSeries();
                        barSeries.setName((String)legendList.get(i));
                        barSeries.setData(((List)valueNameList.get(i)).toArray(new String[((List)valueNameList.get(i)).size()]));
                        barChart.addSeries((SeriesOption)barSeries);
                    }
                }
                Engine engineBar = new Engine();
                String string3 = engineBar.renderJsonOption((Chart)barChart);
                break;
            }
            case "pie": {
                Object o;
                tooltip = new Tooltip();
                tooltip.setTrigger("item");
                tooltip.setFormatter("{a} <br/>{b}: {c} ({d}%)");
                legend = new Legend();
                legend.setOrient("horizontal");
                legend.setTop("bottom");
                title = new Title();
                title.setText("");
                title.setLeft("left");
                Pie pieChart = (Pie)((Pie)((Pie)new Pie().setLegend(legend)).setTitle(title)).setTooltip(tooltip);
                List collectPointName = points.stream().map(Point::getName).collect(Collectors.toList());
                List collectValueName = values.stream().map(Value::getName).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(collectPointName) && CollectionUtils.isNotEmpty(collectValueName) && collectPointName.size() == 1 && collectValueName.size() == 1) {
                    ArrayList seriesListMap = new ArrayList();
                    for (Map<String, Object> map : chartBase.getDatas()) {
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        o = map.get(collectPointName.get(0));
                        hashMap.put("name", o);
                        Object object = map.get(collectValueName.get(0));
                        hashMap.put("value", object);
                        seriesListMap.add(hashMap);
                    }
                    PieSeries pieSeries = new PieSeries();
                    pieSeries.setData(seriesListMap).setRadius("50%").setType("pie").setName((String)legendList.get(0));
                    pieChart.addSeries((SeriesOption)pieSeries);
                }
                if (CollectionUtils.isNotEmpty(collectPointName) && CollectionUtils.isNotEmpty(collectValueName) && collectPointName.size() > 1) {
                    HashMap<Object, Object> valuesSeries = new HashMap<Object, Object>();
                    for (Map<String, Object> map : chartBase.getDatas()) {
                        void var25_65;
                        HashMap hashMap = new HashMap();
                        o = map.get(collectPointName.get(0));
                        Object var25_62 = null;
                        try {
                            Double d = (Double)map.get(collectValueName.get(0));
                        }
                        catch (Exception e) {
                            log.info("\u7ed3\u679c\uff1a" + map.get(collectValueName.get(0)) + "\uff0c\u65e0\u6cd5\u5f3a\u8f6c\u4e3aDouble");
                            Integer integerValue = (Integer)map.get(collectValueName.get(0));
                            Double d = integerValue.doubleValue();
                        }
                        if (valuesSeries.containsKey(o)) {
                            double currentSum = (Double)valuesSeries.get(o);
                            valuesSeries.put(o, currentSum + var25_65.doubleValue());
                            continue;
                        }
                        valuesSeries.put(o, var25_65);
                    }
                    ArrayList seriesListMap2 = new ArrayList();
                    for (Map.Entry entry : valuesSeries.entrySet()) {
                        HashMap<String, Object> map2 = new HashMap<String, Object>();
                        map2.put("name", entry.getKey());
                        map2.put("value", entry.getValue());
                        seriesListMap2.add(map2);
                    }
                    PieSeries pieSeries = new PieSeries();
                    pieSeries.setData(seriesListMap2).setRadius(new String[]{"0", "30%"}).setType("pie").setName((String)legendList.get(0));
                    pieChart.addSeries((SeriesOption)pieSeries);
                    ArrayList arrayList = new ArrayList();
                    for (Map map : chartBase.getDatas()) {
                        HashMap map3 = new HashMap();
                        Object o2 = map.get(collectPointName.get(collectPointName.size() - 1));
                        map3.put("name", o2);
                        Object o1 = map.get(collectValueName.get(0));
                        map3.put("value", o1);
                        arrayList.add(map3);
                    }
                    PieSeries pieSeries2 = new PieSeries();
                    pieSeries2.setData(arrayList).setRadius(new String[]{"45%", "60%"}).setType("pie").setName((String)legendList.get(0));
                    pieChart.addSeries((SeriesOption)pieSeries2);
                }
                Engine enginePie = new Engine();
                String string4 = enginePie.renderJsonOption((Chart)pieChart);
                break;
            }
        }
        Option option = (Option)new Gson().fromJson((String)var10_16, Option.class);
        digiwin.chartsdk.beans.sdk.chart.Option option1 = new digiwin.chartsdk.beans.sdk.chart.Option();
        BeanUtils.copyProperties((Object)option, (Object)option1);
        return option1;
    }
}

