/*
 * Decompiled with CFR 0.152.
 */
package digiwin.chartsdk.utils;

import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.ChartDataMetric;
import digiwin.chartsdk.beans.sdk.chart.ChartValue;
import digiwin.chartsdk.beans.sdk.chart.Point;
import digiwin.chartsdk.beans.sdk.chart.Value;
import digiwin.chartsdk.utils.ChartDataUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class ChartAttributes {
    public static void fillAnalysis(ChartBase chartBase, Value value, ChartValue chartValue, Point point) {
        ArrayList<Map<String, Object>> values = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : chartBase.getDatas()) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("value", ChartDataUtils.getChartData(map.get(value.getName())));
            ArrayList<ChartDataMetric> dimensionData = new ArrayList<ChartDataMetric>();
            List<ChartDataMetric> measurementData = new ArrayList<ChartDataMetric>();
            ChartDataMetric dataMetric = new ChartDataMetric(point.getTitle(), map.get(point.getName()));
            dimensionData.add(dataMetric);
            if (CollectionUtils.isNotEmpty(value.getDimensionValue())) {
                dimensionData.addAll(ChartAttributes.getDataMetric(value.getDimensionValue(), map));
            }
            if (CollectionUtils.isNotEmpty(value.getMeasurementValue())) {
                measurementData = ChartAttributes.getDataMetric(value.getMeasurementValue(), map);
            } else {
                measurementData.add(new ChartDataMetric(value.getTitle(), map.get(value.getName())));
            }
            data.put("dimensionData", dimensionData);
            data.put("measurementData", measurementData);
            values.add(data);
        }
        chartValue.setValues(values);
    }

    private static List<ChartDataMetric> getDataMetric(List<Value> values, Map<String, Object> map) {
        ArrayList<ChartDataMetric> dataMetrics = new ArrayList<ChartDataMetric>();
        values.forEach(dimensionValue -> dataMetrics.add(new ChartDataMetric(dimensionValue.getTitle(), map.get(dimensionValue.getName()))));
        return dataMetrics;
    }
}

