/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.app.cloud.resources.aop;

import com.digiwin.app.cloud.resources.aop.ServiceInvocationUsageUploadRunnable;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.dap.middleware.lmc.LMCClient;
import com.digiwin.dap.middleware.lmc.request.SaveEventLog;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ServiceInvocationUsageRecorder
implements DisposableBean {
    private static Log log = LogFactory.getLog(ServiceInvocationUsageRecorder.class);
    private ExecutorService executorService;
    private int batchSize;
    private int capacity;
    private ArrayBlockingQueue<SaveEventLog> saveEventLogs;
    @Autowired
    private LMCClient lmcClient;

    public ServiceInvocationUsageRecorder(ExecutorService executorService, int batchSize) {
        this.executorService = executorService;
        this.batchSize = batchSize;
        this.capacity = batchSize * 5;
        this.saveEventLogs = new ArrayBlockingQueue(this.capacity);
    }

    public void put(SaveEventLog eventLog) throws InterruptedException {
        boolean success = this.saveEventLogs.offer(eventLog, 1L, TimeUnit.SECONDS);
        if (!success) {
            throw new DWRuntimeException(String.format("unexpected capacity exhausted! batchSize=%s, capacity=%s", this.batchSize, this.capacity));
        }
        if (this.saveEventLogs.size() >= this.batchSize) {
            this.upload(this.batchSize);
        }
    }

    public void upload() {
        if (this.saveEventLogs.size() > 0) {
            this.upload(this.batchSize);
        } else {
            log.info((Object)"ServiceInvocationUsageRecorder nothing to upload.");
        }
    }

    private void upload(int size) {
        ArrayList<SaveEventLog> uploadList = new ArrayList<SaveEventLog>();
        try {
            for (int i = 0; i < size; ++i) {
                uploadList.add((SaveEventLog)this.saveEventLogs.remove());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (uploadList.size() > 0) {
            this.executorService.submit(new ServiceInvocationUsageUploadRunnable(log, this.lmcClient, uploadList));
        }
    }

    public void destroy() {
        log.info((Object)"ServiceInvocationUsageRecorder ready to destroy...");
        this.upload(this.saveEventLogs.size());
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

