/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.common.configuration;

import com.digiwin.commons.common.esclient.HttpIndicesClient;
import com.digiwin.commons.common.esclient.HttpOprationEsClient;
import com.digiwin.commons.datasource.ElasticSearchDatasource;
import com.digiwin.commons.utils.JSONUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"default.elastic.enable"}, havingValue="true")
public class ElasticSearchConfig {
    private Properties properties;
    @Value(value="${default.elastic.connection-param:{\"address\":\"172.16.2.191:9200\",\"user\":\"elastic\",\"password\":\"digiwin@123\",\"port\":\"9600\",\"httpBasicAccount\":\"Basic sadkjsad1\"}}")
    private String connectionParam;
    @Value(value="${default.elastic.old-connection-param:{\"address\":\"172.16.2.191\",\"user\":\"elastic\",\"password\":\"digiwin@123\",\"port\":\"9200\",\"httpBasicAccount\":\"Basic sadkjsad1\"}}")
    private String oldConnectionParam;

    @Bean
    public RestHighLevelClient restHighLevelClient() {
        ElasticSearchDatasource es = JSONUtils.parseObject(this.getConnectionParam(), ElasticSearchDatasource.class);
        List<String> clusterHostList = Arrays.asList(es.getAddress().split(","));
        HttpHost[] httpHosts = new HttpHost[clusterHostList.size()];
        for (int i = 0; i < clusterHostList.size(); ++i) {
            String[] hostArray = clusterHostList.get(i).split(":");
            httpHosts[i] = new HttpHost(hostArray[0], Integer.valueOf(hostArray[1]).intValue());
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(es.getUser(), es.getPassword()));
        return new RestHighLevelClient(RestClient.builder((HttpHost[])httpHosts).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
            final /* synthetic */ CredentialsProvider val$credentialsProvider;
            {
                this.val$credentialsProvider = credentialsProvider;
            }

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
            }
        }));
    }

    @Bean
    public HttpOprationEsClient httpOprationEsClient() {
        HttpOprationEsClient httpOprationEsClient = JSONUtils.parseObject(this.getOldConnectionParam(), HttpOprationEsClient.class);
        httpOprationEsClient.setHttpUrl(String.format("http://%s:%s", httpOprationEsClient.getAddress(), httpOprationEsClient.getPort()));
        httpOprationEsClient.setHttpIndicesClient(new HttpIndicesClient(httpOprationEsClient));
        return httpOprationEsClient;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getConnectionParam() {
        return this.connectionParam;
    }

    public String getOldConnectionParam() {
        return this.oldConnectionParam;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setConnectionParam(String connectionParam) {
        this.connectionParam = connectionParam;
    }

    public void setOldConnectionParam(String oldConnectionParam) {
        this.oldConnectionParam = oldConnectionParam;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticSearchConfig)) {
            return false;
        }
        ElasticSearchConfig other = (ElasticSearchConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Properties this$properties = this.getProperties();
        Properties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$connectionParam = this.getConnectionParam();
        String other$connectionParam = other.getConnectionParam();
        if (this$connectionParam == null ? other$connectionParam != null : !this$connectionParam.equals(other$connectionParam)) {
            return false;
        }
        String this$oldConnectionParam = this.getOldConnectionParam();
        String other$oldConnectionParam = other.getOldConnectionParam();
        return !(this$oldConnectionParam == null ? other$oldConnectionParam != null : !this$oldConnectionParam.equals(other$oldConnectionParam));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticSearchConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Properties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $connectionParam = this.getConnectionParam();
        result = result * 59 + ($connectionParam == null ? 43 : $connectionParam.hashCode());
        String $oldConnectionParam = this.getOldConnectionParam();
        result = result * 59 + ($oldConnectionParam == null ? 43 : $oldConnectionParam.hashCode());
        return result;
    }

    public String toString() {
        return "ElasticSearchConfig(properties=" + this.getProperties() + ", connectionParam=" + this.getConnectionParam() + ", oldConnectionParam=" + this.getOldConnectionParam() + ")";
    }
}

