/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.common.processor;

import com.digiwin.commons.common.esclient.HttpOprationEsClient;
import com.digiwin.commons.common.esclient.request.HttpStatsRequest;
import com.digiwin.commons.dto.DocDelete;
import com.digiwin.commons.dto.DocInsert;
import com.digiwin.commons.dto.DocQuery;
import com.digiwin.commons.dto.DocUpdate;
import com.digiwin.commons.dto.EsDocUpdateById;
import com.digiwin.commons.dto.Index;
import com.digiwin.commons.enums.AnalysisSourceType;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.utils.CollectionsUtils;
import com.digiwin.commons.utils.JSONUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.PutMappingRequest;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class EsBaseProcessor {
    private static final Logger log = LoggerFactory.getLogger(EsBaseProcessor.class);
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    private HttpOprationEsClient httpOprationEsClient;

    public abstract Boolean indexCreate(Index var1);

    public abstract Boolean checkIndexExists(Index var1) throws IOException;

    public abstract Object docBatchInsert(DocInsert var1) throws Exception;

    public abstract Boolean docBatchDeleteById(DocDelete var1);

    public abstract Boolean docDeleteByQuery(DocQuery var1);

    public abstract Object query(DocQuery var1);

    public abstract Boolean docUpdateById(DocUpdate var1) throws Exception;

    public Boolean dropIndex(Index index) throws Exception {
        DeleteIndexRequest request = new DeleteIndexRequest(index.getName());
        AcknowledgedResponse delete = this.restHighLevelClient.indices().delete(request, RequestOptions.DEFAULT);
        return delete.isAcknowledged();
    }

    public Object queryEsIndexStorageInfo(DocQuery docQuery) {
        try {
            HttpStatsRequest httpStatsRequest = new HttpStatsRequest(docQuery.getIndex());
            String searchResponse = this.httpOprationEsClient.queryEsIndexStorageInfo(httpStatsRequest);
            log.info(" searchResponse : {} ", (Object)searchResponse);
            return JSONUtils.parseObject(searchResponse);
        }
        catch (Exception e) {
            log.info(" query es error , e: {} ", (Throwable)e);
            throw new BusinessException("query es error !");
        }
    }

    public Object partialUpdateByQuery(EsDocUpdateById dto) {
        String field = dto.getSourceType().getDesc();
        UpdateResponse updateResponse = null;
        try {
            UpdateRequest request = new UpdateRequest(dto.getIndex(), dto.getId());
            Map<String, List<Integer>> stringListMap = Collections.singletonMap("data", dto.getTargetId());
            Script inline = new Script(ScriptType.INLINE, "painless", String.format(dto.getOpType().getScript(), field, "data"), stringListMap);
            request.script(inline);
            request.upsert(this.getIndexRequest(dto));
            updateResponse = this.restHighLevelClient.update(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            log.error(" partial update by query error ,e : {}", (Throwable)e);
        }
        return updateResponse;
    }

    public void alterIndexAddColumn(String index, String field, RestHighLevelClient client) throws IOException {
        PutMappingRequest put = new PutMappingRequest(new String[]{index});
        XContentBuilder builder = XContentFactory.jsonBuilder();
        builder.startObject();
        builder.startObject("properties");
        builder.startObject(field);
        builder.field("type", "keyword");
        builder.endObject();
        builder.endObject();
        builder.endObject();
        put.source(builder);
        client.indices().putMapping(put, RequestOptions.DEFAULT);
    }

    public Response getIndexMapping(String index) throws IOException {
        return this.executeHttp("", "GET", index, "_mapping", null);
    }

    public Response executeHttp(String param, String method, String index, String op, Map<String, String> paramMap) throws IOException {
        RestClient restClient = this.restHighLevelClient.getLowLevelClient();
        NStringEntity entity = new NStringEntity(param, ContentType.APPLICATION_JSON);
        Request request = new Request(method, String.format("/%s/%s", index, op));
        request.addParameters(Objects.nonNull(paramMap) ? paramMap : Collections.emptyMap());
        request.setEntity((HttpEntity)entity);
        return restClient.performRequest(request);
    }

    private IndexRequest getIndexRequest(EsDocUpdateById dto) {
        HashMap jsonMap = new HashMap();
        ArrayList add = new ArrayList();
        ArrayList del = new ArrayList();
        switch (dto.getOpType()) {
            case OP_ADD_BATCH: {
                Optional.ofNullable(dto.getTargetId()).filter(CollectionsUtils::notEmpty).ifPresent(i -> add.addAll(i));
                break;
            }
        }
        jsonMap.put(AnalysisSourceType.DAAS_API.getDesc(), add);
        jsonMap.put(AnalysisSourceType.DS_WORKFLOW.getDesc(), del);
        return new IndexRequest(dto.getIndex()).id(dto.getId()).source(jsonMap);
    }
}

