/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.common.processor;

import com.digiwin.commons.common.esclient.HttpOprationEsClient;
import com.digiwin.commons.common.esclient.request.HttpDeleteRequest;
import com.digiwin.commons.common.esclient.request.HttpIndexRequest;
import com.digiwin.commons.common.esclient.request.HttpInsertRequest;
import com.digiwin.commons.common.esclient.request.HttpSearchRequest;
import com.digiwin.commons.common.esclient.request.HttpUpdateRequest;
import com.digiwin.commons.common.processor.EsBaseProcessor;
import com.digiwin.commons.dto.DocDelete;
import com.digiwin.commons.dto.DocInsert;
import com.digiwin.commons.dto.DocQuery;
import com.digiwin.commons.dto.DocUpdate;
import com.digiwin.commons.dto.Index;
import com.digiwin.commons.enums.Status;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.utils.CollectionsUtils;
import com.digiwin.commons.utils.JSONUtils;
import com.digiwin.commons.utils.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component(value="esHttpProcessor")
@ConditionalOnProperty(name={"default.elastic.enable"}, havingValue="true")
public class EsHttpProcessor
extends EsBaseProcessor {
    private static final Logger log = LoggerFactory.getLogger(EsHttpProcessor.class);
    @Autowired
    private HttpOprationEsClient httpOprationEsClient;

    @Override
    public Boolean indexCreate(Index index) {
        Boolean flag = true;
        try {
            if (this.checkIndexExists(index).booleanValue()) {
                log.info(" index already exists ! ");
                throw new BusinessException(Status.INDEX_ALREADY_EXISTS);
            }
            HttpIndexRequest httpIndexRequest = new HttpIndexRequest(index.getName());
            Optional.ofNullable(index.getIndexParam()).filter(StringUtils::isNotBlank).ifPresent(i -> httpIndexRequest.setIndexParam((String)i));
            String resultInfo = this.httpOprationEsClient.indices().create(httpIndexRequest);
            log.info(" create index result : {} ", (Object)resultInfo);
        }
        catch (Exception e) {
            log.error(" create index error , e : {} ", (Throwable)e);
            throw new BusinessException("create index error !");
        }
        return flag;
    }

    @Override
    public Boolean checkIndexExists(Index index) throws IOException {
        HttpIndexRequest httpIndexRequest = new HttpIndexRequest(index.getName());
        Boolean exists = this.httpOprationEsClient.indices().exists(httpIndexRequest);
        return exists;
    }

    @Override
    public Object docBatchInsert(DocInsert docs) throws Exception {
        Boolean flag = true;
        try {
            if (!CollectionsUtils.notEmpty(docs.getDataMap()).booleanValue()) {
                log.info(" es data batch insert , index : {} , size is zero ! ", (Object)docs.getIndex());
                return flag;
            }
            log.info(" start to execute batch insert , index : {} , size : {} ", (Object)docs.getIndex(), (Object)docs.getDataMap().size());
            HttpInsertRequest httpInsertRequest = new HttpInsertRequest(docs.getIndex(), docs.getType());
            if (StringUtils.isNotBlank(docs.getAttachment())) {
                httpInsertRequest.setPipeline(docs.getAttachment());
            }
            if (StringUtils.isNotBlank(docs.getRouting())) {
                httpInsertRequest.routing(docs.getRouting());
            }
            httpInsertRequest.setDataMap(docs.getDataMap());
            this.httpOprationEsClient.bulkInsert(httpInsertRequest);
            log.info(" execute batch insert success , index : {} , size : {} ", (Object)docs.getIndex(), (Object)docs.getDataMap().size());
        }
        catch (Exception e) {
            log.error(" doc batch insert error , e : {} ", (Throwable)e);
            throw new BusinessException("doc insert error !");
        }
        return flag;
    }

    @Override
    public Boolean docBatchDeleteById(DocDelete docs) {
        Boolean flag = true;
        if (!CollectionsUtils.notEmpty(docs.getDataList()).booleanValue()) {
            log.info(" es data batch delete by id , index : {} , size is zero ! ", (Object)docs.getIndex());
            return flag;
        }
        log.info(" start to execute batch delete , index : {} , size : {} ", (Object)docs.getIndex(), (Object)docs.getDataList().size());
        try {
            HttpDeleteRequest httpDeleteRequest = new HttpDeleteRequest(docs.getIndex(), docs.getType());
            if (StringUtils.isNotBlank(docs.getRouting())) {
                httpDeleteRequest.routing(docs.getRouting());
            }
            httpDeleteRequest.setDataList(docs.getDataList());
            this.httpOprationEsClient.bulkDeleteById(httpDeleteRequest);
        }
        catch (Exception e) {
            log.error(" delete doc error,e :{} ", (Throwable)e);
            throw new BusinessException("delete doc error \uff01");
        }
        log.info(" execute batch delete success , index : {} , size : {} ", (Object)docs.getIndex(), (Object)docs.getDataList().size());
        return flag;
    }

    @Override
    public Boolean docDeleteByQuery(DocQuery docQuery) {
        Boolean flag = true;
        try {
            HttpSearchRequest httpSearchRequest = new HttpSearchRequest(docQuery.getIndex(), docQuery.getType());
            if (StringUtils.isNotBlank(docQuery.getRouting())) {
                httpSearchRequest.routing(docQuery.getRouting());
            }
            httpSearchRequest.setQueryParam(docQuery.getParam());
            this.httpOprationEsClient.docDeleteByQuery(httpSearchRequest);
        }
        catch (Exception e) {
            log.error(" doc delete by query error , e:{}", (Throwable)e);
            throw new BusinessException("doc delete by query error");
        }
        return flag;
    }

    @Override
    public Object query(DocQuery docQuery) {
        try {
            String queryParamJson = docQuery.getParam() == null ? JSONUtils.toJsonString(docQuery.getJsonParam()) : docQuery.getParam();
            HttpSearchRequest httpSearchRequest = new HttpSearchRequest(docQuery.getIndex(), docQuery.getType());
            if (StringUtils.isNotBlank(docQuery.getRouting())) {
                httpSearchRequest.routing(docQuery.getRouting());
            }
            httpSearchRequest.setQueryParam(queryParamJson);
            String searchResponse = this.httpOprationEsClient.query(httpSearchRequest);
            log.info(" searchResponse : {} ", (Object)searchResponse);
            return JSONUtils.parseObject(searchResponse);
        }
        catch (Exception e) {
            log.info(" query es error , e: {} ", (Throwable)e);
            throw new BusinessException("query es error !");
        }
    }

    @Override
    public Boolean docUpdateById(DocUpdate docUpdate) throws Exception {
        Boolean flag = true;
        if (!CollectionsUtils.notEmpty(docUpdate.getIdList()).booleanValue()) {
            log.info(" es data batch update by id , index : {} , size is zero ! ", (Object)docUpdate.getIndex());
            return flag;
        }
        log.info(" start to execute batch update , index : {} , size : {} ", (Object)docUpdate.getIndex(), (Object)docUpdate.getIdList().size());
        try {
            HttpUpdateRequest httpUpdateRequest = new HttpUpdateRequest(docUpdate.getIndex(), docUpdate.getType());
            if (StringUtils.isNotBlank(docUpdate.getRouting())) {
                httpUpdateRequest.routing(docUpdate.getRouting());
            }
            HashMap<String, String> dataMap = new HashMap<String, String>();
            Optional.ofNullable(docUpdate.getIdList()).filter(CollectionsUtils::notEmpty).ifPresent(i -> i.forEach(k -> dataMap.put((String)k, JSONUtils.toJsonString(docUpdate.getDataMap()))));
            httpUpdateRequest.setDataMap(dataMap);
            this.httpOprationEsClient.bulkUpdateById(httpUpdateRequest);
        }
        catch (Exception e) {
            log.error(" update doc error,e :{} ", (Throwable)e);
            throw new BusinessException(" update doc error!");
        }
        log.info(" execute batch update success , index : {} , size : {} ", (Object)docUpdate.getIndex(), (Object)docUpdate.getIdList().size());
        return flag;
    }
}

