/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.dto;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.enums.EsOprationTypeEnum;
import com.digiwin.commons.utils.ElasticRestClientUtils;
import com.digiwin.commons.utils.JSONUtils;
import com.digiwin.commons.utils.StringUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.ScriptAssert;
import org.springframework.util.ObjectUtils;

@ScriptAssert(script="com.digiwin.commons.dto.Index.checkParam(_this.indexParam,_this.indexParamJson)", lang="javascript", message="indexParam \u53ea\u80fd\u4e3a\u7d22\u5f15\u7684\u914d\u7f6e\u4fe1\u606f")
public class Index {
    @NotNull(message="index name can not be null!")
    private @NotNull(message="index name can not be null!") String name;
    private String indexParam;
    private JSONObject indexParamJson;
    private EsOprationTypeEnum esOprationTypeEnum;

    @JsonCreator
    private Index(String name, String indexParam, JSONObject indexParamJson) {
        this.name = name;
        this.indexParam = indexParam;
        this.indexParamJson = indexParamJson;
        if (StringUtils.isBlank(indexParam)) {
            this.indexParam = JSONUtils.toJson(indexParamJson);
        }
        this.esOprationTypeEnum = ElasticRestClientUtils.readConfigEsOpMode(name);
    }

    public Index() {
    }

    public static Boolean checkParam(String indexParam, JSONObject indexParamJson) {
        AtomicBoolean flag = new AtomicBoolean(false);
        if (StringUtils.isBlank(indexParam)) {
            indexParam = JSONUtils.toJson(indexParamJson);
        }
        Optional.ofNullable(indexParam).filter(StringUtils::isNotBlank).ifPresent(i -> {
            JSONObject param = JSONObject.parseObject((String)i);
            flag.set(IndexParamKey.checkContains(param.keySet()));
        });
        return flag.get();
    }

    public String getName() {
        return this.name;
    }

    public String getIndexParam() {
        return this.indexParam;
    }

    public JSONObject getIndexParamJson() {
        return this.indexParamJson;
    }

    public EsOprationTypeEnum getEsOprationTypeEnum() {
        return this.esOprationTypeEnum;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setIndexParam(String indexParam) {
        this.indexParam = indexParam;
    }

    public void setIndexParamJson(JSONObject indexParamJson) {
        this.indexParamJson = indexParamJson;
    }

    public void setEsOprationTypeEnum(EsOprationTypeEnum esOprationTypeEnum) {
        this.esOprationTypeEnum = esOprationTypeEnum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Index)) {
            return false;
        }
        Index other = (Index)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$indexParam = this.getIndexParam();
        String other$indexParam = other.getIndexParam();
        if (this$indexParam == null ? other$indexParam != null : !this$indexParam.equals(other$indexParam)) {
            return false;
        }
        JSONObject this$indexParamJson = this.getIndexParamJson();
        JSONObject other$indexParamJson = other.getIndexParamJson();
        if (this$indexParamJson == null ? other$indexParamJson != null : !this$indexParamJson.equals(other$indexParamJson)) {
            return false;
        }
        EsOprationTypeEnum this$esOprationTypeEnum = this.getEsOprationTypeEnum();
        EsOprationTypeEnum other$esOprationTypeEnum = other.getEsOprationTypeEnum();
        return !(this$esOprationTypeEnum == null ? other$esOprationTypeEnum != null : !((Object)((Object)this$esOprationTypeEnum)).equals((Object)other$esOprationTypeEnum));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Index;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $indexParam = this.getIndexParam();
        result = result * 59 + ($indexParam == null ? 43 : $indexParam.hashCode());
        JSONObject $indexParamJson = this.getIndexParamJson();
        result = result * 59 + ($indexParamJson == null ? 43 : $indexParamJson.hashCode());
        EsOprationTypeEnum $esOprationTypeEnum = this.getEsOprationTypeEnum();
        result = result * 59 + ($esOprationTypeEnum == null ? 43 : ((Object)((Object)$esOprationTypeEnum)).hashCode());
        return result;
    }

    public String toString() {
        return "Index(name=" + this.getName() + ", indexParam=" + this.getIndexParam() + ", indexParamJson=" + this.getIndexParamJson() + ", esOprationTypeEnum=" + (Object)((Object)this.getEsOprationTypeEnum()) + ")";
    }

    public Index(String name, String indexParam, JSONObject indexParamJson, EsOprationTypeEnum esOprationTypeEnum) {
        this.name = name;
        this.indexParam = indexParam;
        this.indexParamJson = indexParamJson;
        this.esOprationTypeEnum = esOprationTypeEnum;
    }

    public static enum IndexParamKey {
        SETTINGS("settings", "\u914d\u7f6e"),
        MAPPINGS("mappings", "\u6620\u5c04"),
        ALIAS("aliases", "\u522b\u540d");

        private final String code;
        private final String desc;

        private IndexParamKey(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }

        public static Boolean checkCodeExists(String code) {
            for (IndexParamKey val : IndexParamKey.values()) {
                if (!ObjectUtils.nullSafeEquals((Object)val.code, (Object)code)) continue;
                return true;
            }
            return false;
        }

        public static Boolean checkContains(Collection<String> collection) {
            List keys = Arrays.stream(IndexParamKey.values()).map(i -> i.code).collect(Collectors.toList());
            return collection.stream().allMatch(i -> keys.contains(i));
        }
    }
}

