/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.common.processor;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.id.NanoId;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.common.processor.EsBaseProcessor;
import com.digiwin.commons.entity.DocDelete;
import com.digiwin.commons.entity.DocInsert;
import com.digiwin.commons.entity.DocQuery;
import com.digiwin.commons.entity.DocUpdate;
import com.digiwin.commons.entity.Index;
import com.digiwin.commons.entity.vo.IndicesDetailsInfo;
import com.digiwin.commons.enums.Status;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.utils.CollectionsUtils;
import com.digiwin.commons.utils.ElasticRestClientUtils;
import com.digiwin.commons.utils.HttpUtils;
import com.digiwin.commons.utils.JSONUtils;
import com.digiwin.commons.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.client.indices.GetIndexResponse;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.TimeValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component(value="esRestClientProcessor")
@ConditionalOnProperty(name={"default.elastic.enable"}, havingValue="true")
public class EsRestClientProcessor
extends EsBaseProcessor {
    private static final Logger log = LoggerFactory.getLogger(EsRestClientProcessor.class);
    @Autowired
    private ElasticRestClientUtils elasticRestClientUtils;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Value(value="${default.elastic.insert.processor-close-time:20}")
    private Long processorCloseTime;

    @Override
    public Boolean indexCreate(Index index) {
        Boolean flag = true;
        try {
            if (this.checkIndexExists(index).booleanValue()) {
                log.info(" index already exists ! ");
                throw new BusinessException(Status.INDEX_ALREADY_EXISTS);
            }
            CreateIndexRequest request = new CreateIndexRequest(index.getName());
            Optional.ofNullable(index.getIndexParam()).filter(StringUtils::isNotBlank).ifPresent(i -> request.source(i, XContentType.JSON));
            CreateIndexResponse createIndexResponse = this.restHighLevelClient.indices().create(request, RequestOptions.DEFAULT);
            log.info(" create index result : {} ", (Object)createIndexResponse.isAcknowledged());
        }
        catch (IOException e) {
            log.error(" create index error , e : {} ", (Throwable)e);
            throw new BusinessException("create index error !");
        }
        return flag;
    }

    @Override
    public Boolean checkIndexExists(Index index) throws IOException {
        Boolean exists = false;
        GetIndexRequest request = new GetIndexRequest(new String[]{index.getName()});
        request.local(false);
        request.humanReadable(true);
        request.includeDefaults(false);
        exists = this.restHighLevelClient.indices().exists(request, RequestOptions.DEFAULT);
        return exists;
    }

    @Override
    public Object docBatchInsert(DocInsert docs) {
        Boolean flag = true;
        BulkRequest request = new BulkRequest(docs.getIndex());
        try {
            log.info(" start to execute batch insert , index : {} , size : {} ", (Object)docs.getIndex(), (Object)docs.getDataMap().size());
            Map<String, String> data = docs.getDataMap();
            if (CollectionsUtils.notEmpty(data).booleanValue()) {
                data.entrySet().forEach(i -> {
                    IndexRequest indexRequest = new IndexRequest(docs.getIndex()).id((String)i.getKey());
                    if (StringUtils.isNotBlank(docs.getAttachment())) {
                        indexRequest.setPipeline(docs.getAttachment());
                    }
                    if (StringUtils.isNotBlank(docs.getRouting())) {
                        indexRequest.routing(docs.getRouting());
                    }
                    indexRequest.source((String)i.getValue(), XContentType.JSON);
                    request.add(indexRequest);
                });
            }
            request.timeout(TimeValue.timeValueSeconds((long)this.processorCloseTime));
            BulkResponse bulkResponse = this.restHighLevelClient.bulk(request, RequestOptions.DEFAULT);
            if (bulkResponse.hasFailures()) {
                ArrayList<String> errorDataList = new ArrayList<String>();
                for (BulkItemResponse bulkItemResponse : bulkResponse) {
                    if (!bulkItemResponse.isFailed()) continue;
                    log.error("bulk item failure message:{}", (Object)bulkItemResponse.getFailure().getCause().getMessage());
                    errorDataList.add(bulkItemResponse.getFailure().getCause().getMessage());
                }
                return errorDataList;
            }
            log.info(" execute batch insert success , index : {} , size : {} ", (Object)docs.getIndex(), (Object)docs.getDataMap().size());
        }
        catch (Exception e) {
            log.error(" doc batch insert error , e : {} ", (Throwable)e);
            throw new BusinessException(e.getMessage());
        }
        return flag;
    }

    @Override
    public Boolean docBatchDeleteById(DocDelete docs) {
        Boolean flag = true;
        log.info(" start to execute batch delete , index : {} , size : {} ", (Object)docs.getIndex(), (Object)docs.getDataList().size());
        AtomicReference<BulkProcessor> processor = new AtomicReference<BulkProcessor>(this.elasticRestClientUtils.getBulkProcessor(this.restHighLevelClient));
        try {
            Optional.ofNullable(docs.getDataList()).filter(CollectionsUtils::notEmpty).ifPresent(i -> i.forEach(k -> {
                DeleteRequest deleteRequest = new DeleteRequest(docs.getIndex(), k);
                if (StringUtils.isNotBlank(docs.getRouting())) {
                    deleteRequest.routing(docs.getRouting());
                }
                ((BulkProcessor)processor.get()).add(deleteRequest);
            }));
            processor.get().awaitClose(this.processorCloseTime.longValue(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            processor.get().close();
            log.error(" delete doc error,e :{} ", (Throwable)e);
            throw new BusinessException("delete doc error \uff01");
        }
        log.info(" execute batch delete success , index : {} , size : {} ", (Object)docs.getIndex(), (Object)docs.getDataList().size());
        return flag;
    }

    @Override
    public Object docDeleteByQuery(DocQuery docQuery) {
        try {
            RestClient restClient = this.restHighLevelClient.getLowLevelClient();
            NStringEntity entity = new NStringEntity(docQuery.getParam(), ContentType.APPLICATION_JSON);
            Request request = new Request("POST", String.format("/%s/%s", docQuery.getIndex(), "_delete_by_query"));
            if (CollectionsUtils.notEmpty((Map)docQuery.getUrlParamJson()).booleanValue()) {
                Map<String, String> urlParamMap = JSONUtils.toMap(JSONUtils.toJson(docQuery.getUrlParamJson()));
                request.addParameters(urlParamMap);
            }
            request.setEntity((HttpEntity)entity);
            Response response = restClient.performRequest(request);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            JSONObject result = JSONUtils.parseObject(responseBody);
            return result.getString("task");
        }
        catch (IOException e) {
            log.error(" doc delete by query error , e:{}", (Throwable)e);
            throw new BusinessException("doc delete by query error");
        }
    }

    @Override
    public Object query(DocQuery docQuery) {
        try {
            String queryParamJson = docQuery.getParam() == null ? JSONUtils.toJsonString(docQuery.getJsonParam()) : docQuery.getParam();
            RestClient restClient = this.restHighLevelClient.getLowLevelClient();
            NStringEntity entity = new NStringEntity(queryParamJson, ContentType.APPLICATION_JSON);
            Request request = new Request("POST", String.format("/%s/%s", docQuery.getIndex(), "_search"));
            if (CollectionsUtils.notEmpty((Map)docQuery.getUrlParamJson()).booleanValue()) {
                Map<String, String> urlParamMap = JSONUtils.toMap(JSONUtils.toJson(docQuery.getUrlParamJson()));
                request.addParameters(urlParamMap);
            }
            request.setEntity((HttpEntity)entity);
            Response response = restClient.performRequest(request);
            return JSONUtils.parseObject(EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        catch (Exception e) {
            log.error(" query es error , e: {} ", (Throwable)e);
            throw new BusinessException("query es error !");
        }
    }

    @Override
    public Boolean docUpdateById(DocUpdate docUpdate) {
        Boolean flag = true;
        log.info(" start to execute batch update , index : {} , size : {} ", (Object)docUpdate.getIndex(), (Object)docUpdate.getIdList().size());
        AtomicReference<BulkProcessor> processor = new AtomicReference<BulkProcessor>(this.elasticRestClientUtils.getBulkProcessor(this.restHighLevelClient));
        try {
            Optional.ofNullable(docUpdate.getIdList()).filter(CollectionsUtils::notEmpty).ifPresent(i -> i.forEach(k -> {
                UpdateRequest updateRequest = new UpdateRequest(docUpdate.getIndex(), k).doc(JSONUtils.toJson(docUpdate.getDataMap()), XContentType.JSON);
                if (StringUtils.isNotBlank(docUpdate.getRouting())) {
                    updateRequest.routing(docUpdate.getRouting());
                }
                ((BulkProcessor)processor.get()).add((DocWriteRequest)updateRequest);
            }));
            processor.get().awaitClose(this.processorCloseTime.longValue(), TimeUnit.SECONDS);
        }
        catch (Exception e) {
            processor.get().close();
            log.error(" update doc error,e :{} ", (Throwable)e);
            throw new BusinessException(" update doc error!");
        }
        log.info(" execute batch update success , index : {} , size : {} ", (Object)docUpdate.getIndex(), (Object)docUpdate.getIdList().size());
        return flag;
    }

    @Override
    public Object indicesGet(Index index) {
        if (StringUtils.isBlank(index.getName())) {
            throw new BusinessException(" index name is null!");
        }
        try {
            IndicesDetailsInfo indicesDetailsInfo = new IndicesDetailsInfo();
            GetIndexRequest request = new GetIndexRequest(new String[]{index.getName()});
            GetIndexResponse getIndexResponse = this.restHighLevelClient.indices().get(request, RequestOptions.DEFAULT);
            BeanUtil.copyProperties((Object)getIndexResponse, (Object)indicesDetailsInfo, (String[])new String[0]);
            return indicesDetailsInfo;
        }
        catch (IOException e) {
            log.error(" query es structure details info error , e: {} ", (Throwable)e);
            throw new BusinessException("query es structure details info error !");
        }
    }

    public static void main(String[] args) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("token", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpYXQiOjE0OTM4OTc3MjI0MTEsInNpZCI6ODIyMDIzMzgxOTg0NjE5NjUwLCJpZCI6ImNvcmVtaWRkbGV3YXJlIn0.DMSIMMmwi5qrq7niOl80nU5VbXjFWlgmclTn2cEiORo");
        JSONObject json = JSONUtils.parseObject("{\"index\":\"lmc_fm_test_fm_idx\",\"type\":\"_doc\",\"dataList\":[\"\"]}");
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (int j = 0; j < 50000; ++j) {
            futures.add(CompletableFuture.runAsync(() -> {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                for (int i = 0; i < 200; ++i) {
                    JSONObject dataJson = null;
                    dataJson = i % 2 == 0 ? JSONUtils.parseObject("{\"id\": \"nghghh\",\"appId\": \"LMC\",\"level\": \"INFO\",\"thread\": \"http-nio-22623-exec-8\",\"loggerName\": \"com.digiwin.dap.middleware.filter.AccessLogFilter\",\"source\": \"3d72f5763e9e\",\"appender\": \"DwMongoLog4j2Appender-str\",\"location\": \"Unknown(Unknown Source)\",\"tenantId\": \"99990000\",\"tenantName\": \"\u9f0e\u6377\u8f6f\u4ef6\",\"message\": \"dsa\",\"appName\": \"\u65e5\u5fd7\u4e2d\u5fc3\",\"address\": \"cehdghahsjahdjadshajbnc\"}") : JSONUtils.parseObject("{\"modifyBy\":0,\"modifyDate\":\"2022-12-14 05:46:00\",\"sysId\":\"Athena\",\"ip\":\"106.14.205.4\",\"eventType\":8,\"userName\":\"\\u865a\\u62df\\u7528\\u6237\",\"userId\":\"virtual\",\"content\":{\"userToken\":\"8b142eff-0b83-4006-b715-dd75dd0cde12\",\"identityType\":\"secretKey\"},\"createBy\":0,\"tenantName\":\"pass\\u533a\\u6d4b\\u8bd5\\u79df\\u6237(WF)\",\"appId\":\"IAM\",\"tenantId\":\"AthenaWFPASS\",\"eventName\":\"\\u7528\\u6237[\\u865a\\u62df\\u7528\\u6237(virtual)]\\uff0c\\u767b\\u5165\\u5e94\\u7528[Athena]\\u6210\\u529f\\uff01\",\"id\":\"71312611-6580-4566-b01c-02e24078ec19\",\"createDate\":\"2022-12-14 05:46:00\",\"status\":0}");
                    String id = NanoId.randomNanoId((int)16);
                    dataJson.put("id", (Object)id);
                    dataMap.put(id, JSONUtils.toJson(dataJson));
                }
                json.put("dataMap", dataMap);
                String post = HttpUtils.post("https://dmp-dmf-hw.digiwincloud.com.cn/search/es/doc/create", JSONUtils.toJson(json), null, header);
                System.out.println("result:" + post);
            }).exceptionally(e -> {
                log.error("test error!,e:{}", e);
                return null;
            }));
        }
        CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).join();
        System.out.println(111);
    }
}

