/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.db;

import com.digiwin.commons.enums.DbType;
import com.digiwin.commons.factory.BeanFactoryContext;
import com.digiwin.commons.processor.db.DbBaseProcessor;
import com.digiwin.commons.processor.db.MysqlDbProcessor;
import com.digiwin.commons.processor.db.OracleDbProcessor;
import com.digiwin.commons.processor.db.SqlServerDbProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(DbProcessorFactory.class);

    public static DbBaseProcessor getDbProcessor(DbType dbType) {
        switch (dbType) {
            case MYSQL: {
                return BeanFactoryContext.findBeanByClass(MysqlDbProcessor.class);
            }
            case ORACLE: {
                return BeanFactoryContext.findBeanByClass(OracleDbProcessor.class);
            }
            case SQLSERVER: {
                return BeanFactoryContext.findBeanByClass(SqlServerDbProcessor.class);
            }
        }
        log.error("unsupport db type: {}", (Object)dbType.getDesc());
        throw new RuntimeException("not support db type");
    }
}

