/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.db;

import com.digiwin.commons.entity.db.ColumnInfo;
import com.digiwin.commons.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DbBaseProcessor {
    private static final Logger log = LoggerFactory.getLogger(DbBaseProcessor.class);

    public String columnLineBreakReplace(String sql, List<ColumnInfo> columnInfoList) {
        try {
            if (CollectionUtils.isEmpty(columnInfoList) || StringUtils.isBlank(sql)) {
                return sql;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add(sql);
            String selectStr = "select";
            String fromStr = "from";
            int startIndex = ((String)list.get(0)).toLowerCase().indexOf(selectStr);
            int endIndex = ((String)list.get(0)).toLowerCase().indexOf(fromStr) + fromStr.length();
            String waitReplaceStr = ((String)list.get(0)).substring(startIndex + selectStr.length(), endIndex);
            String replaceStr = "";
            for (ColumnInfo columnInfo : columnInfoList) {
                replaceStr = waitReplaceStr.replace(columnInfo.getColumnName(), String.format("replace(replace(replace(%s,char(13),''),char(10),''),'\\n','') as %s", columnInfo.getColumnName(), columnInfo.getColumnName()));
            }
            sql = sql.replace(waitReplaceStr, replaceStr);
        }
        catch (Exception e) {
            log.error("column line break replace error!:{}", (Throwable)e);
            return sql;
        }
        return sql;
    }
}

