/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.sql;

import com.digiwin.commons.entity.sql.BaseEqCondition;
import com.digiwin.commons.entity.sql.ConcatType;
import com.digiwin.commons.entity.sql.EqualsType;
import com.digiwin.commons.entity.sql.RangeType;
import com.digiwin.commons.entity.sql.StandardQuery;
import com.digiwin.commons.utils.CollectionsUtils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BaseProcessor {
    Logger log = LoggerFactory.getLogger(BaseProcessor.class);
    String CONSTANT_BACK_QUOTE = "`";

    public StringBuilder dealFilterConditions(BaseEqCondition baseEqCondition, StringBuilder sb, ConcatType concatType, EqualsType equalsType, Map<String, Boolean> ifNumber) {
        String concat = concatType.getCode();
        Optional.ofNullable(baseEqCondition.getTerm()).ifPresent(i -> {
            if (i.entrySet().size() > 0) {
                i.forEach((key, value) -> {
                    sb.append(concat).append(" ").append((String)key).append(equalsType.getCode());
                    if (ifNumber.getOrDefault(key, false).booleanValue()) {
                        sb.append(value).append(" ");
                    } else {
                        sb.append("\"").append(value).append("\" ");
                    }
                });
            }
        });
        Optional.ofNullable(baseEqCondition.getTerms()).ifPresent(i -> {
            if (i.entrySet().size() > 0) {
                i.forEach((key, value) -> {
                    if (value.size() > 0) {
                        sb.append(concat).append(" ").append((String)key).append(" ").append(equalsType.getName()).append("(");
                        ArrayList<String> valueList = new ArrayList<String>();
                        if (value.get(0) instanceof List && !CollectionUtils.isEmpty((Collection)((List)value.get(0)))) {
                            for (Object valueObj : (List)value.get(0)) {
                                valueList.add(this.concatSingleQuote(String.valueOf(valueObj)));
                            }
                        }
                        sb.append(String.join((CharSequence)",", valueList));
                        sb.append(") ");
                    }
                });
            }
        });
        Optional.ofNullable(baseEqCondition.getWildcard()).ifPresent(i -> {
            if (i.entrySet().size() > 0) {
                i.forEach((key, value) -> sb.append(concat).append(" ").append((String)key).append(" ").append(equalsType.name().replace("_", " ")).append(" \"").append((String)value).append("\" "));
            }
        });
        Optional.ofNullable(baseEqCondition.getRange()).ifPresent(i -> {
            if (i.entrySet().size() > 0) {
                i.forEach((key, jsonObject) -> {
                    if (jsonObject.entrySet().size() > 0) {
                        jsonObject.forEach((key1, value) -> {
                            sb.append(concat).append(" ").append((String)key).append(RangeType.of(key1).getCode());
                            if (ifNumber.getOrDefault(key, false).booleanValue()) {
                                sb.append(value).append(" ");
                            } else {
                                sb.append("\"").append(value).append("\" ");
                            }
                        });
                    }
                });
            }
        });
        return sb;
    }

    public List<Map> analysisResultSet(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        ArrayList<Map> lists = new ArrayList<Map>();
        while (rs.next()) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int i = 1; i <= columnCount; ++i) {
                String column = md.getColumnName(i);
                row.put(column, rs.getObject(column));
            }
            lists.add(row);
        }
        return lists;
    }

    public String concatSql(StandardQuery standardQuery) {
        Map<String, Boolean> columnType = standardQuery.getColumnType();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        List<String> columns = standardQuery.getColumn();
        if (!CollectionUtils.isEmpty(columns)) {
            sb.append(String.join((CharSequence)",", columns)).append(" ");
        } else {
            sb.append("* ");
        }
        sb.append("FROM ").append(standardQuery.getTable()).append(" ");
        this.joinCondition(standardQuery, sb);
        sb.append("WHERE 1=1 ");
        Optional.ofNullable(standardQuery.getConditions()).ifPresent(list -> list.forEach(i -> {
            String type = Optional.ofNullable(i.getType()).orElse("AND");
            sb.append(type).append("(");
            Optional.ofNullable(i.getAndCondition()).ifPresent(and -> {
                Optional.ofNullable(and.getEq()).ifPresent(eq -> this.dealFilterConditions((BaseEqCondition)eq, sb, ConcatType.AND, EqualsType.LIKE, columnType));
                Optional.ofNullable(and.getNotEq()).ifPresent(notEq -> this.dealFilterConditions((BaseEqCondition)notEq, sb, ConcatType.AND, EqualsType.NOT_LIKE, columnType));
            });
            Optional.ofNullable(i.getOrCondition()).ifPresent(or -> {
                Optional.ofNullable(or.getEq()).ifPresent(eq -> this.dealFilterConditions((BaseEqCondition)eq, sb, ConcatType.AND, EqualsType.LIKE, columnType));
                Optional.ofNullable(or.getNotEq()).ifPresent(notEq -> this.dealFilterConditions((BaseEqCondition)notEq, sb, ConcatType.AND, EqualsType.NOT_LIKE, columnType));
            });
            sb.append(")");
        }));
        List<StringBuilder> contains = Collections.singletonList(new StringBuilder(sb.toString().replace("AND(  )", "").replace("OR(  )", "").replace("(AND", "(").replace("(OR", "(")));
        Optional.ofNullable(standardQuery.getGroup()).ifPresent(column -> {
            if (!CollectionUtils.isEmpty((Collection)column)) {
                ((StringBuilder)contains.get(0)).append("GROUP BY ").append(column.stream().collect(Collectors.joining(","))).append(" ");
            }
        });
        this.orderByCondition(standardQuery, contains);
        this.limitCondition(standardQuery, contains);
        String sql = contains.get(0).toString();
        this.log.info("sql : {}", (Object)sql);
        return sql;
    }

    public void joinCondition(StandardQuery standardQuery, StringBuilder sb) {
        Optional.ofNullable(standardQuery.getJoin()).filter(i -> i.size() > 0).ifPresent(list -> list.forEach(join -> Optional.ofNullable(join).ifPresent(i -> {
            if (i.checkParam().booleanValue()) {
                sb.append(i.getType()).append(" ").append(i.getTable()).append(" ON 1=1 ");
                i.getConnection().forEach((key, val) -> {
                    if (!StringUtils.isEmpty((Object)key) && !StringUtils.isEmpty((Object)val)) {
                        sb.append("AND ").append((String)key).append("=").append((String)val).append(" ");
                    }
                });
            }
        })));
    }

    public void orderByCondition(StandardQuery standardQuery, List<StringBuilder> contains) {
        Map<String, String> maping = standardQuery.getAliesMaping();
        Optional.ofNullable(standardQuery.getOrder()).filter(CollectionsUtils::notEmpty).ifPresent(i -> {
            String orderInfo = i.stream().map(k -> this.CONSTANT_BACK_QUOTE + maping.getOrDefault(k.getColumn(), k.getColumn()) + this.CONSTANT_BACK_QUOTE + " " + k.getType()).collect(Collectors.joining(","));
            ((StringBuilder)contains.get(0)).append(" ORDER BY ").append(orderInfo).append(" ");
        });
    }

    public void limitCondition(StandardQuery standardQuery, List<StringBuilder> contains) {
        if (ObjectUtils.isEmpty((Object)standardQuery.getLimit())) {
            return;
        }
        contains.get(0).append(" LIMIT ").append(standardQuery.getLimit().getOffset()).append(",").append(standardQuery.getLimit().getLimits());
    }

    private String concatSingleQuote(String dest) {
        return "'" + dest + "'";
    }
}

