/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.common;

import com.digiwin.commons.utils.MDCUtils;
import com.digiwin.commons.utils.StringUtils;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.MDC;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Order(value=10)
@Component
@ConditionalOnClass(value={WebMvcConfigurer.class})
public class TraceIDInterceptor
implements HandlerInterceptor {
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String traceId = request.getHeader("TRACE_ID");
        traceId = Optional.ofNullable(traceId).filter(StringUtils::isNotBlank).orElseGet(StringUtils::getNewTraceID);
        MDCUtils.setTraceIDToMdc(traceId);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        MDC.remove((String)"TRACE_ID");
    }
}

