/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.commons.utils.StringUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONUtils {
    private static final Logger logger = LoggerFactory.getLogger(JSONUtils.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JSONUtils() {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setTimeZone(TimeZone.getDefault());
    }

    public static String toJson(Object object) {
        try {
            return JSON.toJSONString((Object)object, (boolean)false);
        }
        catch (Exception e) {
            logger.error("object to json exception!", (Throwable)e);
            return null;
        }
    }

    public static <T> T parseObject(String json, Class<T> clazz) {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        try {
            return (T)JSON.parseObject((String)json, clazz);
        }
        catch (Exception e) {
            logger.error("parse object exception!", (Throwable)e);
            return null;
        }
    }

    public static <T> T parseObject(byte[] src, Class<T> clazz) {
        if (src == null) {
            return null;
        }
        String json = new String(src, StandardCharsets.UTF_8);
        return JSONUtils.parseObject(json, clazz);
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        if (StringUtils.isEmpty(json)) {
            return new ArrayList();
        }
        try {
            return JSONArray.parseArray((String)json, clazz);
        }
        catch (Exception e) {
            logger.error("JSONArray.parseArray exception!", (Throwable)e);
            return new ArrayList();
        }
    }

    public static <T> byte[] toJsonByteArray(T obj) {
        if (obj == null) {
            return null;
        }
        String json = "";
        try {
            json = JSONUtils.toJsonString(obj);
        }
        catch (Exception e) {
            logger.error("json serialize exception.", (Throwable)e);
        }
        return json.getBytes(StandardCharsets.UTF_8);
    }

    public static boolean checkJsonValid(String json) {
        if (StringUtils.isEmpty(json)) {
            return false;
        }
        try {
            objectMapper.readTree(json);
            return true;
        }
        catch (IOException e) {
            logger.error("check json object valid exception!", (Throwable)e);
            return false;
        }
    }

    public static boolean checkJsonArrayValid(String json) {
        if (StringUtils.isEmpty(json)) {
            return false;
        }
        try {
            JSON.parseArray((String)json);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String findValue(JsonNode jsonNode, String fieldName) {
        JsonNode node = jsonNode.findValue(fieldName);
        if (node == null) {
            return null;
        }
        return node.toString();
    }

    public static Map<String, String> toMap(String json) {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        try {
            return (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<HashMap<String, String>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            logger.error("json to map exception!", (Throwable)e);
            return null;
        }
    }

    public static <K, V> Map<K, V> toMap(String json, Class<K> classK, Class<V> classV) {
        if (StringUtils.isEmpty(json)) {
            return null;
        }
        try {
            return (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<HashMap<K, V>>(){}, (Feature[])new Feature[0]);
        }
        catch (Exception e) {
            logger.error("json to map exception!", (Throwable)e);
            return null;
        }
    }

    public static String toJsonString(Object object) {
        try {
            return JSON.toJSONString((Object)object, (boolean)false);
        }
        catch (Exception e) {
            throw new RuntimeException("Object json deserialization exception.", e);
        }
    }

    public static JSONObject parseObject(String text) {
        try {
            return JSON.parseObject((String)text);
        }
        catch (Exception e) {
            throw new RuntimeException("String json deserialization exception.", e);
        }
    }

    public static JSONArray parseArray(String text) {
        try {
            return JSON.parseArray((String)text);
        }
        catch (Exception e) {
            throw new RuntimeException("Json deserialization exception.", e);
        }
    }

    public static class JsonDataDeserializer
    extends JsonDeserializer<String> {
        public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return node.toString();
        }
    }

    public static class JsonDataSerializer
    extends JsonSerializer<String> {
        public void serialize(String value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeRawValue(value);
        }
    }
}

