/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.alibaba.fastjson.JSON;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Encoder;

@Component
public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);
    private static String pushFilePath;

    @Value(value="${push-data-file-path}")
    public void setpushFilePath(String pushFilePath) {
        FileUtils.pushFilePath = pushFilePath;
    }

    public static String fileToBase64(MultipartFile file) throws IOException {
        String base64EncoderImg = null;
        try {
            BASE64Encoder base64Encoder = new BASE64Encoder();
            base64EncoderImg = base64Encoder.encode(file.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("\u6587\u4ef6\u89e3\u6790\u5931\u8d25");
        }
        return base64EncoderImg.replace("\n", "").replace("\r", "");
    }

    public static void fileUploadServer(MultipartFile file, String serverName, String fileId) {
        String fileName = pushFilePath + serverName + "/";
        File folder = new File(fileName);
        if (!folder.exists() && !folder.isDirectory()) {
            folder.mkdir();
        }
        if (file != null && !file.isEmpty()) {
            fileName = fileName + fileId + file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf("."));
            try {
                file.transferTo(new File(fileName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getFileSuffix(MultipartFile file) {
        String originalFilename = file.getOriginalFilename();
        int lastIndexOf = originalFilename.lastIndexOf(".");
        String suffix = originalFilename.substring(lastIndexOf + 1);
        return suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadJsonTypeFile(HttpServletResponse response, List dataList) {
        response.setContentType("application/json;charset=UTF-8");
        try {
            ServletOutputStream out = response.getOutputStream();
            try {
                BufferedOutputStream buff = new BufferedOutputStream((OutputStream)out);
                try {
                    buff.write(JSON.toJSONString((Object)dataList).getBytes(StandardCharsets.UTF_8));
                    buff.flush();
                    buff.close();
                }
                finally {
                    if (Collections.singletonList(buff).get(0) != null) {
                        buff.close();
                    }
                }
            }
            finally {
                if (Collections.singletonList(out).get(0) != null) {
                    out.close();
                }
            }
        }
        catch (IOException e) {
            log.error("export process fail: {}", (Throwable)e);
        }
    }

    public static String file2String(MultipartFile file) {
        StringBuilder strBuilder = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);){
            String inputStr;
            BufferedReader streamReader = new BufferedReader(inputStreamReader);
            while ((inputStr = streamReader.readLine()) != null) {
                strBuilder.append(inputStr);
            }
        }
        catch (IOException e) {
            log.error("file convert to string failed: {}", (Object)file.getName());
        }
        return strBuilder.toString();
    }
}

