/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import org.springframework.util.ObjectUtils;

public enum UserType {
    ADMIN_USER(0, "admin user"),
    GENERAL_USER(1, "general user");

    @EnumValue
    private final int code;
    private final String descp;

    private UserType(int code, String descp) {
        this.code = code;
        this.descp = descp;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescp() {
        return this.descp;
    }

    public static Integer code(String name) {
        if (name == null) {
            return null;
        }
        for (UserType ty : UserType.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.name(), (Object)name)) continue;
            return ty.getCode();
        }
        return null;
    }

    public static Integer of(int type) {
        for (UserType ty : UserType.values()) {
            if (ty.getCode() != type) continue;
            return ty.getCode();
        }
        return null;
    }

    public static UserType get(int type) {
        for (UserType ty : UserType.values()) {
            if (ty.getCode() != type) continue;
            return ty;
        }
        return null;
    }
}

