/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.assets;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.common.Result;
import com.digiwin.commons.entity.DocInsert;
import com.digiwin.commons.entity.vo.assets.DataAssetsVO;
import com.digiwin.commons.entity.vo.dap.TDapTableVO;
import com.digiwin.commons.enums.DataCatalogClassificationType;
import com.digiwin.commons.feign.client.DaasService;
import com.digiwin.commons.processor.assets.DataAssetsBaseProcessor;
import com.digiwin.commons.utils.JSONUtils;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DataTableProcessor
extends DataAssetsBaseProcessor<TDapTableVO> {
    private static final Logger log = LoggerFactory.getLogger(DataTableProcessor.class);
    @Autowired
    private DaasService daasService;

    @Override
    public void save(TDapTableVO tDapTableVO) {
        DocInsert docInsert = new DocInsert();
        docInsert.setIndex("dmp_full_data_idx");
        HashMap<String, JSONObject> dataJsonMap = new HashMap<String, JSONObject>();
        DataAssetsVO dataAssetsVO = new DataAssetsVO();
        dataAssetsVO.setId(tDapTableVO.getId());
        dataAssetsVO.setTableGuId(tDapTableVO.getTableGuId());
        dataAssetsVO.setCode(tDapTableVO.getCode());
        dataAssetsVO.setName(tDapTableVO.getName());
        dataAssetsVO.setCreateTime(new Date());
        dataAssetsVO.setDataType(DataCatalogClassificationType.DATA_TABLE.getCode());
        dataAssetsVO.setCarryOut(tDapTableVO.getIsCarryOut());
        dataAssetsVO.setDataWarehouseId(tDapTableVO.getDataWarehouseId());
        dataJsonMap.put(String.valueOf(tDapTableVO.getId()), JSONUtils.parseObject(JSONUtils.toJson(dataAssetsVO)));
        docInsert.setDataJsonMap(dataJsonMap);
        this.daasService.saveEsInfo(docInsert);
    }

    @Override
    public void remove(Integer id) {
    }

    @Override
    public void update(TDapTableVO tDapTableVO) {
    }

    @Override
    public TDapTableVO getToEsArgs(Object ... dataParam) {
        TDapTableVO tDapTableVO = JSONUtils.parseObject(JSONUtils.toJson(dataParam[0]), TDapTableVO.class);
        Result result = JSONUtils.parseObject(JSONUtils.toJson(dataParam[1]), Result.class);
        tDapTableVO.setId(Integer.valueOf(String.valueOf(result.getData())));
        return null;
    }
}

