/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.EnumUtil;
import cn.hutool.core.util.ObjectUtil;
import com.digiwin.commons.common.annotation.EnumDict;
import com.digiwin.commons.entity.MetricEnumDict;
import com.digiwin.commons.entity.MetricEnumInfo;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class DictUtils {
    public static final Logger logger = LoggerFactory.getLogger(DictUtils.class);

    static Class<? extends Enum<?>> castEnumType(Class<?> enumType) {
        return enumType;
    }

    public static List<MetricEnumDict> getEnumDictByPackageName(String packageName) {
        Set classSet = ClassUtil.scanPackageBySuper((String)packageName, Serializable.class);
        ArrayList<MetricEnumDict> dictList = new ArrayList<MetricEnumDict>();
        classSet.stream().filter(Class::isEnum).forEach(enumClass -> {
            Map<Integer, String> codeNameMap = DictUtils.getCodeNameMap(enumClass);
            List<MetricEnumInfo> dictValue = DictUtils.getDictValue(enumClass);
            if (CollectionUtils.isEmpty(dictValue)) {
                return;
            }
            dictValue.forEach(dict -> {
                int code = dict.getCode();
                dict.setName((String)codeNameMap.get(code));
            });
            dictList.add(new MetricEnumDict(DictUtils.getDictName(enumClass), dictValue));
        });
        return dictList;
    }

    private static Map<Integer, String> getCodeNameMap(Class<?> enumClass) {
        Class<? extends Enum<?>> aClass = DictUtils.castEnumType(enumClass);
        Map nameFieldMap = EnumUtil.getNameFieldMap(aClass, (String)"code");
        LinkedHashMap<Integer, String> codeNameMap = new LinkedHashMap<Integer, String>();
        if (!CollectionUtils.isEmpty((Map)nameFieldMap)) {
            nameFieldMap.forEach((name, code) -> {
                if (ObjectUtil.isNotEmpty((Object)code) && code instanceof Integer) {
                    codeNameMap.put((Integer)code, (String)name);
                }
            });
        }
        return codeNameMap;
    }

    private static String getDictName(Class<?> enumClass) {
        EnumDict annotation = enumClass.getAnnotation(EnumDict.class);
        String dictName = enumClass.getSimpleName();
        if (ObjectUtil.isNotEmpty((Object)annotation) && StringUtils.isNotBlank((String)annotation.name())) {
            dictName = annotation.name();
        } else if (StringUtils.isNotBlank((String)dictName) && dictName.length() > 1) {
            dictName = Character.toLowerCase(dictName.charAt(0)) + dictName.substring(1);
        }
        return dictName;
    }

    private static List<MetricEnumInfo> getDictValue(Class<?> enumClass) {
        ?[] enumConstants = enumClass.getEnumConstants();
        ArrayList<MetricEnumInfo> enumValueList = new ArrayList<MetricEnumInfo>();
        for (Object x : enumConstants) {
            Optional<MetricEnumInfo> metricEnumInfo = DictUtils.checkFieldAnnotation(x);
            if (!metricEnumInfo.isPresent()) {
                return new ArrayList<MetricEnumInfo>();
            }
            enumValueList.add(metricEnumInfo.get());
        }
        return enumValueList;
    }

    private static Optional<MetricEnumInfo> checkFieldAnnotation(Object enumObject) {
        Field[] fields = enumObject.getClass().getDeclaredFields();
        MetricEnumInfo metricEnumInfo = new MetricEnumInfo();
        Arrays.stream(fields).filter(field -> field.isAnnotationPresent(EnumDict.class)).forEach(field -> DictUtils.putMetricEnumInfoValue(enumObject, field, metricEnumInfo));
        if (ObjectUtil.isNotEmpty((Object)metricEnumInfo.getCode()) && StringUtils.isNotBlank((String)metricEnumInfo.getDesc())) {
            return Optional.of(metricEnumInfo);
        }
        return Optional.empty();
    }

    private static void putMetricEnumInfoValue(Object enumObject, Field field, MetricEnumInfo metricEnumInfo) {
        block7: {
            try {
                field.setAccessible(true);
                EnumDict annotation = field.getAnnotation(EnumDict.class);
                if (!ObjectUtil.isNotEmpty((Object)annotation) || !ObjectUtil.isNotEmpty((Object)annotation.value()) || !ObjectUtil.isNotEmpty((Object)field.get(enumObject))) break block7;
                Object value = field.get(enumObject);
                switch (annotation.value()) {
                    case 0: {
                        if (ObjectUtil.isNotEmpty((Object)Integer.parseInt(String.valueOf(value)))) {
                            metricEnumInfo.setCode(Integer.parseInt(String.valueOf(value)));
                        }
                        break;
                    }
                    case 1: {
                        metricEnumInfo.setDesc(String.valueOf(value));
                        break;
                    }
                    default: {
                        logger.error("annotation value() is invalid");
                    }
                }
            }
            catch (IllegalAccessException e) {
                logger.error("get field failed");
            }
        }
    }
}

