/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.assets;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.common.Result;
import com.digiwin.commons.entity.DocDelete;
import com.digiwin.commons.entity.DocInsert;
import com.digiwin.commons.entity.dto.pipeline.PipelineDTO;
import com.digiwin.commons.entity.vo.assets.DataAssetsVO;
import com.digiwin.commons.enums.DataCatalogClassificationType;
import com.digiwin.commons.feign.client.DaasService;
import com.digiwin.commons.feign.client.DsService;
import com.digiwin.commons.processor.assets.DataAssetsBaseProcessor;
import com.digiwin.commons.utils.JSONUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataPipelineProcessor
extends DataAssetsBaseProcessor<PipelineDTO> {
    private static final Logger log = LoggerFactory.getLogger(DataPipelineProcessor.class);
    @Autowired
    private DaasService daasService;
    @Autowired
    private DsService dsService;

    @Override
    public void save(PipelineDTO pipelineDTO) {
        HashMap<String, JSONObject> dataJsonMap = new HashMap<String, JSONObject>();
        DataAssetsVO dataAssetsVO = new DataAssetsVO();
        dataAssetsVO.setId(pipelineDTO.getId());
        dataAssetsVO.setName(pipelineDTO.getName());
        dataAssetsVO.setCreateTime(new Date());
        dataAssetsVO.setDataType(DataCatalogClassificationType.DATA_PIPELINE.getCode());
        dataAssetsVO.setProject(pipelineDTO.getProjectName());
        String key = String.valueOf(pipelineDTO.getId()).concat("_").concat(DataCatalogClassificationType.DATA_PIPELINE.name());
        dataJsonMap.put(key, JSONUtils.parseObject(JSONUtils.toJson(dataAssetsVO)));
        DocInsert docInsert = new DocInsert();
        docInsert.setIndex("dmp_full_data_idx");
        docInsert.setDataJsonMap(dataJsonMap);
        this.daasService.saveEsInfo(docInsert);
    }

    @Override
    public void update(PipelineDTO pipelineDTO) {
        this.remove(pipelineDTO.getId());
        this.save(pipelineDTO);
    }

    @Override
    public void remove(Object obj) {
        Object[] args = (Object[])obj;
        DocDelete docDelete = new DocDelete();
        docDelete.setIndex("dmp_full_data_idx");
        ArrayList<String> dataList = new ArrayList<String>();
        String id = String.valueOf(args[2]).concat("_").concat(DataCatalogClassificationType.DATA_PIPELINE.name());
        dataList.add(id);
        docDelete.setDataList(dataList);
        this.daasService.deleteEsInfo(docDelete);
    }

    @Override
    public PipelineDTO getToEsArgs(Object ... dataParam) {
        Object[] args = (Object[])dataParam[0];
        PipelineDTO pipelineDTO = JSONUtils.parseObject(JSONUtils.toJson(args[1]), PipelineDTO.class);
        if (pipelineDTO.getId() == null || pipelineDTO.getId() == 0) {
            Result result = JSONUtils.parseObject(JSONUtils.toJson(dataParam[1]), Result.class);
            pipelineDTO.setId(Integer.valueOf(String.valueOf(result.getData())));
        }
        pipelineDTO.setProjectName(String.valueOf(args[2]));
        return pipelineDTO;
    }
}

