/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.assets;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.common.Result;
import com.digiwin.commons.entity.DocDelete;
import com.digiwin.commons.entity.DocInsert;
import com.digiwin.commons.entity.dto.daas.TDapCatalogRelationResourceDTO;
import com.digiwin.commons.entity.vo.assets.DataAssetsVO;
import com.digiwin.commons.entity.vo.dap.TDapTableVO;
import com.digiwin.commons.entity.vo.ds.DataSourceVo;
import com.digiwin.commons.enums.DataCatalogClassificationType;
import com.digiwin.commons.feign.client.DaasService;
import com.digiwin.commons.feign.client.DsService;
import com.digiwin.commons.feign.client.MetaService;
import com.digiwin.commons.processor.assets.DataAssetsBaseProcessor;
import com.digiwin.commons.utils.JSONUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataTableProcessor
extends DataAssetsBaseProcessor<TDapTableVO> {
    private static final Logger log = LoggerFactory.getLogger(DataTableProcessor.class);
    @Autowired
    private DaasService daasService;
    @Autowired
    private MetaService metaService;
    @Autowired
    private DsService dsService;

    @Override
    public void save(TDapTableVO tDapTableVO) {
        DocInsert docInsert = new DocInsert();
        docInsert.setIndex("dmp_full_data_idx");
        HashMap<String, JSONObject> dataJsonMap = new HashMap<String, JSONObject>();
        DataAssetsVO dataAssetsVO = new DataAssetsVO();
        dataAssetsVO.setId(tDapTableVO.getId());
        dataAssetsVO.setTableGuId(tDapTableVO.getTableGuId());
        dataAssetsVO.setCode(tDapTableVO.getCode());
        dataAssetsVO.setName(tDapTableVO.getName());
        dataAssetsVO.setCreateTime(new Date());
        dataAssetsVO.setDataType(DataCatalogClassificationType.DATA_TABLE.getCode());
        dataAssetsVO.setCarryOut(tDapTableVO.getIsCarryOut());
        dataAssetsVO.setDatasourceId(tDapTableVO.getDatasourceId());
        dataAssetsVO.setDataWarehouseId(tDapTableVO.getDataWarehouseId());
        dataAssetsVO.setSourceSystem(tDapTableVO.getSourceSystem());
        dataAssetsVO.setDbName(tDapTableVO.getDbName());
        dataAssetsVO.setDbType(tDapTableVO.getDataSourceType());
        dataAssetsVO.setTableGuId(tDapTableVO.getTableGuId());
        String key = String.valueOf(tDapTableVO.getId()).concat("_").concat(DataCatalogClassificationType.DATA_TABLE.name());
        dataJsonMap.put(key, JSONUtils.parseObject(JSONUtils.toJson(dataAssetsVO)));
        docInsert.setDataJsonMap(dataJsonMap);
        this.daasService.saveEsInfo(docInsert);
    }

    @Override
    public void bindCatalog(TDapTableVO tDapTableVO) {
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(tDapTableVO.getId()).catalogIds(tDapTableVO.getCatalogIds()).classificationType(DataCatalogClassificationType.DATA_PIPELINE.getCode()).build();
        this.dsService.bindCatalogToResource(dto);
    }

    @Override
    public void remove(Object obj) {
        DocDelete docDelete = new DocDelete();
        docDelete.setIndex("dmp_full_data_idx");
        ArrayList<String> dataList = new ArrayList<String>();
        dataList.add(String.valueOf(obj).concat("_").concat(DataCatalogClassificationType.DATA_TABLE.name()));
        docDelete.setDataList(dataList);
        this.daasService.deleteEsInfo(docDelete);
    }

    @Override
    public void update(TDapTableVO tDapTableVO) {
        this.remove(tDapTableVO.getId());
        this.save(tDapTableVO);
    }

    @Override
    public void carryOut(Integer id) {
        Result result = this.dsService.queryTableById(id);
        TDapTableVO tDapTableVO = JSONUtils.parseObject(JSONUtils.toJson(result.getData()), TDapTableVO.class);
        tDapTableVO.setIsCarryOut(1);
        this.remove(tDapTableVO.getId());
        this.save(tDapTableVO);
    }

    @Override
    public TDapTableVO getToEsArgs(Object ... dataParam) {
        Object[] args = (Object[])dataParam[0];
        TDapTableVO tDapTableVO = JSONUtils.parseObject(JSONUtils.toJson(args[0]), TDapTableVO.class);
        if (tDapTableVO.getId() == null) {
            Result result = JSONUtils.parseObject(JSONUtils.toJson(dataParam[1]), Result.class);
            tDapTableVO.setId(Integer.valueOf(String.valueOf(result.getData())));
        }
        Result datasourceResult = this.dsService.queryDatasourceInfoByWarehouse(tDapTableVO.getDataWarehouseId());
        DataSourceVo dataSourceVo = JSONUtils.parseObject(JSONUtils.toJson(datasourceResult.getData()), DataSourceVo.class);
        tDapTableVO.setDbName(dataSourceVo.getDatabaseName());
        tDapTableVO.setDatasourceId(dataSourceVo.getId());
        tDapTableVO.setDataSourceType(dataSourceVo.getType().getCode());
        tDapTableVO.setSourceSystem(dataSourceVo.getSourceSystem());
        if (tDapTableVO.getIsCarryOut() != null && 1 == tDapTableVO.getIsCarryOut()) {
            String qualifiedName = tDapTableVO.getDbName().concat("@").concat(tDapTableVO.getCode());
            Result<String> guidResult = this.metaService.queryAtlasTableGuid(qualifiedName);
            tDapTableVO.setTableGuId(guidResult.getData());
        }
        return tDapTableVO;
    }
}

