/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.assets;

import com.digiwin.commons.entity.dto.daas.TDapCatalogRelationResourceDTO;
import com.digiwin.commons.entity.vo.dap.TDapTableVO;
import com.digiwin.commons.enums.DataCatalogClassificationType;
import com.digiwin.commons.feign.client.DaasService;
import com.digiwin.commons.feign.client.DsService;
import com.digiwin.commons.feign.client.MetaService;
import com.digiwin.commons.processor.assets.DataAssetsBaseProcessor;
import com.digiwin.commons.utils.JSONUtils;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataTableProcessor
extends DataAssetsBaseProcessor<TDapTableVO> {
    private static final Logger log = LoggerFactory.getLogger(DataTableProcessor.class);
    @Autowired
    private DaasService daasService;
    @Autowired
    private MetaService metaService;
    @Autowired
    private DsService dsService;

    @Override
    public void save(TDapTableVO tDapTableVO) {
    }

    @Override
    public void bindCatalog(TDapTableVO tDapTableVO) {
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceIds(Collections.singletonList(tDapTableVO.getId())).catalogIds(tDapTableVO.getCatalogIds()).classificationType(DataCatalogClassificationType.DATA_TABLE.getCode()).build();
        this.dsService.bindCatalogToResource(dto);
    }

    @Override
    public void unbindCatalog(Object[] args) {
        Integer id = Integer.valueOf(String.valueOf(args[0]));
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceIds(Collections.singletonList(id)).classificationType(DataCatalogClassificationType.DATA_TABLE.getCode()).build();
        this.dsService.bindCatalogToResource(dto);
    }

    @Override
    public void remove(Object obj) {
    }

    @Override
    public void update(TDapTableVO tDapTableVO) {
    }

    @Override
    public void carryOut(Integer id) {
    }

    @Override
    public TDapTableVO getToEsArgs(Object ... dataParam) {
        Object[] args = (Object[])dataParam[0];
        TDapTableVO tDapTableVO = JSONUtils.parseObject(JSONUtils.toJson(args[0]), TDapTableVO.class);
        return tDapTableVO;
    }
}

