/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.utils;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.entity.sql.AndCondition;
import com.digiwin.commons.entity.sql.BaseEqCondition;
import com.digiwin.commons.entity.sql.Condition;
import com.digiwin.commons.entity.sql.Equals;
import com.digiwin.commons.entity.sql.NotEquals;
import com.digiwin.commons.entity.sql.OrCondition;
import com.digiwin.commons.entity.sql.RangeType;
import com.digiwin.commons.entity.sql.SqlCondition;
import com.digiwin.commons.entity.sql.SqlOperateType;
import com.digiwin.commons.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.CollectionUtils;

public class SqlUtils {
    public static List<Condition> handleSqlCondition(List<SqlCondition> reqColumns, String operator) {
        HashMap<Integer, BaseEqCondition> map = new HashMap<Integer, BaseEqCondition>();
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        if (CollectionUtils.isEmpty(reqColumns)) {
            return new ArrayList<Condition>();
        }
        for (SqlCondition k : reqColumns) {
            Equals eq = new Equals();
            NotEquals neq = new NotEquals();
            map.put(SqlOperateType.EQ.getType(), eq);
            map.put(SqlOperateType.NOT_EQ.getType(), neq);
            SqlOperateType op = SqlOperateType.of(k.getCondition());
            BaseEqCondition base = (BaseEqCondition)map.get(op.getType());
            switch (op) {
                case EQ: 
                case NOT_EQ: {
                    Map term = Optional.ofNullable(base.getTerm()).orElse(new HashMap());
                    term.put(SqlUtils.concatBackQuote(k.getColumn()), k.getValue());
                    base.setTerm(term);
                    break;
                }
                case IN: 
                case NOT_IN: {
                    Map terms = Optional.ofNullable(base.getTerms()).orElse(new HashMap());
                    List list = Optional.ofNullable(terms.get(k.getColumn())).orElse(new ArrayList());
                    String[] valueList = Optional.ofNullable(k.getValue()).filter(StringUtils::notNull).map(value -> value.split(",")).orElse(new String[0]);
                    list.add(Arrays.asList(valueList));
                    terms.put(SqlUtils.concatBackQuote(k.getColumn()), list);
                    base.setTerms(terms);
                    break;
                }
                case LIKE: 
                case NOT_LIKE: {
                    Map wildcard = Optional.ofNullable(base.getWildcard()).orElse(new HashMap());
                    wildcard.put(SqlUtils.concatBackQuote(k.getColumn()), SqlUtils.convertToPlaceholder(k.getValue()));
                    base.setWildcard(wildcard);
                    break;
                }
                case LESS_THEN: 
                case LESS_EQ_THEN: 
                case MORN_EQ_THEN: 
                case MORN_THEN: {
                    Map range = Optional.ofNullable(base.getRange()).orElse(new HashMap());
                    JSONObject json = Optional.ofNullable(range.get(k.getColumn())).orElse(new JSONObject());
                    json.put(RangeType.get(op.getId()).getName(), (Object)k.getValue());
                    range.put(SqlUtils.concatBackQuote(k.getColumn()), json);
                    base.setRange(range);
                }
            }
            Condition condition = new Condition();
            switch (operator) {
                case "AND": {
                    condition = Condition.builder().type("AND").andCondition(AndCondition.builder().eq((Equals)map.get(SqlOperateType.EQ.getType())).notEq((NotEquals)map.get(SqlOperateType.NOT_EQ.getType())).build()).build();
                    break;
                }
                case "OR": {
                    condition = Condition.builder().type("OR").orCondition(OrCondition.builder().eq((Equals)map.get(SqlOperateType.EQ.getType())).notEq((NotEquals)map.get(SqlOperateType.NOT_EQ.getType())).build()).build();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + operator);
                }
            }
            conditionList.add(condition);
        }
        return conditionList;
    }

    public static String concatBackQuote(String dest) {
        return "`" + dest + "`";
    }

    public static String convertToPlaceholder(String str) {
        return "%" + str + "%";
    }
}

