/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.processor.assets;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.common.Result;
import com.digiwin.commons.entity.DocDelete;
import com.digiwin.commons.entity.DocInsert;
import com.digiwin.commons.entity.dto.daas.DaasApiDTO;
import com.digiwin.commons.entity.dto.daas.TDapCatalogRelationResourceDTO;
import com.digiwin.commons.entity.vo.assets.DataAssetsVO;
import com.digiwin.commons.enums.DataCatalogClassificationType;
import com.digiwin.commons.feign.client.DaasService;
import com.digiwin.commons.feign.client.DsService;
import com.digiwin.commons.processor.assets.DataAssetsBaseProcessor;
import com.digiwin.commons.utils.JSONUtils;
import com.digiwin.commons.utils.StringUtils;
import feign.Request;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class DataServiceProcessor
extends DataAssetsBaseProcessor<DaasApiDTO> {
    private static final Logger log = LoggerFactory.getLogger(DataServiceProcessor.class);
    @Autowired
    private DaasService daasService;
    @Autowired
    private DsService dsService;

    @Override
    public void save(DaasApiDTO daasApiDTO) {
        HashMap<String, JSONObject> dataJsonMap = new HashMap<String, JSONObject>();
        DataAssetsVO dataAssetsVO = new DataAssetsVO();
        dataAssetsVO.setId(daasApiDTO.getId());
        dataAssetsVO.setName(daasApiDTO.getDisplayName());
        dataAssetsVO.setCode(daasApiDTO.getApiName());
        dataAssetsVO.setCreateTime(new Date());
        dataAssetsVO.setDataType(DataCatalogClassificationType.DATA_API.getCode());
        String key = String.valueOf(daasApiDTO.getId()).concat("_").concat(DataCatalogClassificationType.DATA_API.name());
        dataJsonMap.put(key, JSONUtils.parseObject(JSONUtils.toJson(dataAssetsVO)));
        DocInsert docInsert = new DocInsert();
        docInsert.setIndex("dmp_full_data_idx");
        docInsert.setDataJsonMap(dataJsonMap);
        this.daasService.saveEsInfo(docInsert, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    @Override
    public void bindCatalog(DaasApiDTO daasApiDTO) {
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(daasApiDTO.getId()).catalogIds(daasApiDTO.getCatalogIds()).classificationType(DataCatalogClassificationType.DATA_API.getCode()).build();
        this.dsService.bindCatalogToResource(dto, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    @Override
    public void unbindCatalog(Object[] args) {
        Integer id = Integer.valueOf(String.valueOf(args[0]));
        this.unbindCatalogById(id);
    }

    private void unbindCatalogById(Integer id) {
        TDapCatalogRelationResourceDTO dto = TDapCatalogRelationResourceDTO.builder().resourceId(id).classificationType(DataCatalogClassificationType.DATA_API.getCode()).build();
        this.dsService.bindCatalogToResource(dto, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
    }

    @Override
    public void update(DaasApiDTO daasApiDTO) {
        if (StringUtils.isEmpty(daasApiDTO.getApiName())) {
            log.info("dont need to update");
            return;
        }
        this.remove(daasApiDTO.getId());
        this.save(daasApiDTO);
    }

    @Override
    public void remove(Object obj) {
        DocDelete docDelete = new DocDelete();
        docDelete.setIndex("dmp_full_data_idx");
        ArrayList<String> dataList = new ArrayList<String>();
        String id = String.valueOf(obj).concat("_").concat(DataCatalogClassificationType.DATA_API.name());
        dataList.add(id);
        docDelete.setDataList(dataList);
        this.daasService.deleteEsInfo(docDelete, new Request.Options(3L, TimeUnit.SECONDS, 8L, TimeUnit.SECONDS, true));
        if (!ObjectUtils.isEmpty((Object)obj)) {
            this.unbindCatalogById(Integer.valueOf(String.valueOf(obj)));
        }
    }

    @Override
    public DaasApiDTO getToEsArgs(Object ... dataParam) {
        Object[] args = (Object[])dataParam[0];
        DaasApiDTO daasApiDTO = JSONUtils.parseObject(JSONUtils.toJson(args[0]), DaasApiDTO.class);
        if (daasApiDTO.getId() == null) {
            Result result = JSONUtils.parseObject(JSONUtils.toJson(dataParam[1]), Result.class);
            daasApiDTO.setId(Integer.valueOf(String.valueOf(result.getData())));
        }
        return daasApiDTO;
    }
}

