/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.feign.client;

import com.digiwin.commons.entity.dto.iam.IamAesKeyDTO;
import com.digiwin.commons.entity.dto.iam.IamLoginDTO;
import com.digiwin.commons.entity.model.IamAnalyzeToken;
import com.digiwin.commons.entity.model.IamUserByToken;
import com.digiwin.commons.entity.model.iam.IamAesPublicKy;
import com.digiwin.commons.entity.model.iam.IamLoginUser;
import com.digiwin.commons.entity.model.iam.IamPermissionUser;
import com.digiwin.commons.entity.model.iam.IamPublicKey;
import com.digiwin.commons.feign.conf.IamFeignConfig;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

@ConditionalOnDiscoveryEnabled
@FeignClient(value="iam-service", url="${iam.feign.url}", configuration={IamFeignConfig.class})
public interface IamService {
    @GetMapping(value={"${iam.api.query-user-info-by-user-token}"})
    @ResponseBody
    public IamUserByToken queryIamUserInfoByUserToken();

    @PostMapping(value={"${iam.api.identity-token-analyze}"})
    @ResponseBody
    public IamAnalyzeToken identityTokenAnalyze();

    @PostMapping(value={"${iam.api.login}"})
    @ResponseBody
    public IamLoginUser login(@RequestBody IamLoginDTO var1);

    @GetMapping(value={"${iam.api.query-public-key}"})
    @ResponseBody
    public IamPublicKey queryPublicKey();

    @PostMapping(value={"${iam.api.query-aes-key}"})
    @ResponseBody
    public IamAesPublicKy queryAesKey(@RequestBody IamAesKeyDTO var1);

    @PostMapping(value={"${iam.api.query-user-permission}"})
    @ResponseBody
    public IamPermissionUser queryUserPermission();
}

