/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.startup;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.entity.dto.iam.IamTenantUserDTO;
import com.digiwin.commons.entity.model.iam.IamResult;
import com.digiwin.commons.entity.model.iam.IamTenantUser;
import com.digiwin.commons.entity.model.iam.IamUserCache;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.feign.client.IamService;
import com.digiwin.commons.utils.JedisUtils;
import com.digiwin.commons.utils.StringUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
@Transactional(rollbackFor={Exception.class})
@ConditionalOnProperty(name={"iam.feign.enable"}, havingValue="true")
public class TDapIamUserCacheService {
    private static final Logger log = LoggerFactory.getLogger(TDapIamUserCacheService.class);
    @Autowired
    private IamService iamService;
    @Autowired
    private JedisUtils jedisUtils;

    public IamUserCache selectByCodeOfNullBuild(Long sId) {
        String userRedisPrefix = this.getUserRedisPrefix(sId);
        String userInfoJson = this.jedisUtils.get(userRedisPrefix);
        if (StringUtils.isNotBlank(userInfoJson)) {
            IamUserCache iamUserCache = (IamUserCache)JSONObject.parseObject((String)userInfoJson, IamUserCache.class);
            return Optional.ofNullable(iamUserCache).orElse(IamUserCache.builder().build());
        }
        IamTenantUser iamTenantUser = this.queryIamTenantAuthUsersByPage(Collections.singletonList(sId));
        if (ObjectUtils.isEmpty((Object)iamTenantUser) || CollectionUtils.isEmpty(iamTenantUser.getList())) {
            log.error("iam Tenant User is empty");
            return IamUserCache.builder().build();
        }
        IamUserCache iamUserCache = iamTenantUser.getList().get(0).buildIamUserCache();
        this.jedisUtils.setex(userRedisPrefix, 3000, JSONObject.toJSONString((Object)iamUserCache));
        return iamUserCache;
    }

    private String getUserRedisPrefix(Long sid) {
        return String.format("iam_user_info_%s", sid);
    }

    private IamTenantUser queryIamTenantAuthUsersByPage(List<Long> sidList) {
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().pageNum("1").userSid(sidList).pageSize("1").build();
        log.info("query Iam Tenant Auth Users By Page, sid :{}", sidList);
        IamResult<IamTenantUser> iamTenantUserResult = this.iamService.queryTenantAuthUsers(iamTenantUserDTO);
        if (!iamTenantUserResult.isSuccess()) {
            log.error("query Iam Tenant Auth Users By Page error , result :{}", iamTenantUserResult);
            throw new BusinessException("query Iam Tenant Auth Users By Page error");
        }
        return iamTenantUserResult.getData();
    }
}

