/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public enum DbType {
    MYSQL(0, "mysql", 1),
    POSTGRESQL(1, "postgresql", 1),
    HIVE(2, "hive", 4),
    SPARK(3, "spark", 4),
    CLICKHOUSE(4, "clickhouse", 4),
    ORACLE(5, "oracle", 1),
    SQLSERVER(6, "sqlserver", 1),
    DB2(7, "db2", 1),
    IMPALA(8, "impala", 4),
    ES(9, "es", 3),
    STARROCKS(10, "starrocks", 4),
    GREENPLUM(11, "greenplum", 1),
    KAFKA(12, "kafka", 2),
    STANDARD(-1, "standard", 0);

    @EnumValue
    private final int code;
    private final String desc;
    private final int type;

    private DbType(int code, String desc, int type) {
        this.code = code;
        this.desc = desc;
        this.type = type;
    }

    public static DbType of(int type) {
        for (DbType ty : DbType.values()) {
            if (ty.getCode() != type) continue;
            return ty;
        }
        return null;
    }

    public static DbType of(String desc) {
        for (DbType ty : DbType.values()) {
            if (!StringUtils.equals((String)ty.getDesc(), (String)desc)) continue;
            return ty;
        }
        return null;
    }

    public static Enum<DbType> indexOf(Integer index) {
        return Arrays.stream(DbType.values()).filter(i -> i.ordinal() == index.intValue()).findAny().orElse(null);
    }

    public int getType() {
        return this.type;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

