/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.feign.conf;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.context.TokenContext;
import com.digiwin.commons.context.UserInfoContext;
import com.digiwin.commons.utils.StringUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.springframework.util.ObjectUtils;

public class FeignGlobalConfig
implements RequestInterceptor {
    public void apply(RequestTemplate requestTemplate) {
        this.isNotBlankSetHeader("digi-middleware-auth-app", TokenContext.getIamAuthAppContext(), requestTemplate);
        this.isNotBlankSetHeader("digi-middleware-auth-user", TokenContext.getIamAuthUserContext(), requestTemplate);
        this.isNotBlankSetHeader("token", TokenContext.getTokenContext(), requestTemplate);
        if (!ObjectUtils.isEmpty((Object)UserInfoContext.getContext())) {
            String userInfo = JSONObject.toJSONString((Object)UserInfoContext.getContext());
            this.isNotBlankSetHeader("userInfo", userInfo, requestTemplate);
        }
    }

    private void isNotBlankSetHeader(String key, String value, RequestTemplate requestTemplate) {
        if (StringUtils.isNotBlank(key) && StringUtils.isNotBlank(value)) {
            requestTemplate.header(key, new String[]{value});
        }
    }
}

