/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.service.impl;

import com.digiwin.commons.context.TokenContext;
import com.digiwin.commons.entity.constant.IamConstant;
import com.digiwin.commons.entity.dto.LoginDTO;
import com.digiwin.commons.entity.dto.iam.IamAesKeyDTO;
import com.digiwin.commons.entity.dto.iam.IamLoginDTO;
import com.digiwin.commons.entity.dto.iam.IamOrgAspectDTO;
import com.digiwin.commons.entity.dto.iam.IamOrgUserDTO;
import com.digiwin.commons.entity.dto.iam.IamRoleDTO;
import com.digiwin.commons.entity.dto.iam.IamTenantDTO;
import com.digiwin.commons.entity.dto.iam.IamTenantUserDTO;
import com.digiwin.commons.entity.dto.iam.IamUserBaseSIdDTO;
import com.digiwin.commons.entity.dto.iam.IamUserDTO;
import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.entity.enums.UserType;
import com.digiwin.commons.entity.model.Result;
import com.digiwin.commons.entity.model.UserInfo;
import com.digiwin.commons.entity.model.iam.IamAesPublicKy;
import com.digiwin.commons.entity.model.iam.IamAnalyzeToken;
import com.digiwin.commons.entity.model.iam.IamAssociationUserInRole;
import com.digiwin.commons.entity.model.iam.IamAuthoredUser;
import com.digiwin.commons.entity.model.iam.IamLoginUser;
import com.digiwin.commons.entity.model.iam.IamOrgAspect;
import com.digiwin.commons.entity.model.iam.IamPermissionUser;
import com.digiwin.commons.entity.model.iam.IamPermissions;
import com.digiwin.commons.entity.model.iam.IamPublicKey;
import com.digiwin.commons.entity.model.iam.IamResult;
import com.digiwin.commons.entity.model.iam.IamRoles;
import com.digiwin.commons.entity.model.iam.IamTenant;
import com.digiwin.commons.entity.model.iam.IamTenantUser;
import com.digiwin.commons.entity.model.iam.IamUserByToken;
import com.digiwin.commons.entity.model.iam.IamUserTenantList;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.feign.client.IamService;
import com.digiwin.commons.service.IamBusinessService;
import com.digiwin.commons.utils.CollectionsUtils;
import com.digiwin.commons.utils.JSONUtils;
import com.digiwin.commons.utils.StringUtils;
import com.digiwin.commons.utils.iam.AESUtils;
import com.digiwin.commons.utils.iam.RSAUtils;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnProperty(name={"iam.feign.enable"}, havingValue="true")
public class IamBusinessServiceImpl
implements IamBusinessService {
    private static final Logger log = LoggerFactory.getLogger(IamBusinessServiceImpl.class);
    @Autowired
    private IamService iamService;
    @Value(value="${dmp.env}")
    private String dmpEnv;
    @Value(value="${dmp.tenant-name-rule.prefix}")
    private String dmpTenantNameRulePrefix;
    @Value(value="${dmp.tenant-name-rule.suffix}")
    private String dmpTenantNameRuleSuffix;
    @Value(value="${iam.app-id}")
    private String appId;

    @Override
    public List<UserInfo> queryUserInfoByNameContent(IamTenantUserDTO iamTenantUserDTO) {
        iamTenantUserDTO.setAppId(this.appId);
        log.info("invoke iam user info by name content params:{}", (Object)JSONUtils.toJson(iamTenantUserDTO));
        IamResult<IamTenantUser> iamTenantUserResult = this.iamService.queryTenantAuthUsers(iamTenantUserDTO);
        log.info("invoke iam user info by name content response:{}", (Object)JSONUtils.toJson(iamTenantUserResult));
        return iamTenantUserResult.getData().getList().stream().map(IamUserByToken::buildIamUserBase).collect(Collectors.toList());
    }

    @Override
    public IamResult<IamTenantUser> queryUserInfoByNameContentResult(IamTenantUserDTO iamTenantUserDTO) {
        iamTenantUserDTO.setAppId(this.appId);
        log.info("invoke iam user info by name content params:{}", (Object)JSONUtils.toJson(iamTenantUserDTO));
        IamResult<IamTenantUser> iamTenantUserResult = this.iamService.queryTenantAuthUsers(iamTenantUserDTO);
        log.info("invoke iam user info by name content response:{}", (Object)JSONUtils.toJson(iamTenantUserResult));
        return iamTenantUserResult;
    }

    @Override
    public Optional<UserInfo> queryUserInfoByName(String userName) {
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().userName(userName).build();
        iamTenantUserDTO.setAppId(this.appId);
        log.info("invoke iam user info by name params:{}", (Object)JSONUtils.toJson(iamTenantUserDTO));
        IamResult<IamTenantUser> iamTenantUserResult = this.iamService.queryTenantAuthUsers(iamTenantUserDTO);
        log.info("invoke iam user info by name response:{}", (Object)JSONUtils.toJson(iamTenantUserDTO));
        if (CollectionUtils.isEmpty(iamTenantUserResult.getData().getList())) {
            return Optional.empty();
        }
        UserInfo userInfo = (UserInfo)iamTenantUserResult.getData().getList().stream().map(IamUserByToken::buildIamUserBase).collect(Collectors.toList()).get(0);
        return Optional.of(userInfo);
    }

    @Override
    public boolean checkUserSidByNameIsEmpty(String userContent, IamUserBaseSIdDTO iamUserBaseSIdDTO) {
        if (StringUtils.isBlank(userContent)) {
            log.info("param user content is empty");
            iamUserBaseSIdDTO.setSidList(Collections.emptyList());
            return false;
        }
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().userContent(userContent).build();
        List<Long> sIdList = this.queryUserInfoByNameContent(iamTenantUserDTO).stream().map(UserInfo::getSid).collect(Collectors.toList());
        iamUserBaseSIdDTO.setSidList(sIdList);
        return CollectionUtils.isEmpty(sIdList);
    }

    @Override
    public Optional<UserInfo> queryUserInfoBySid(Long sid) {
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().userSids(Collections.singletonList(sid)).build();
        log.info("invoke iam user info by sid params:{}", (Object)JSONUtils.toJson(iamTenantUserDTO));
        IamResult<List<IamUserByToken>> iamTenantUserIamResult = this.iamService.queryUserBySids(iamTenantUserDTO);
        log.info("invoke iam user info by sid response:{}", (Object)JSONUtils.toJson(iamTenantUserIamResult));
        if (CollectionsUtils.notEmpty(iamTenantUserIamResult.getData()).booleanValue()) {
            List userInfoList = iamTenantUserIamResult.getData().stream().map(IamUserByToken::buildIamUserBase).collect(Collectors.toList());
            return Optional.of(userInfoList.get(0));
        }
        return Optional.empty();
    }

    @Override
    public List<UserInfo> queryBatchUserInfoBySidList(List<Long> userSid) {
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().userSids(userSid).build();
        log.info("invoke iam user info by sid params:{}", (Object)JSONUtils.toJson(iamTenantUserDTO));
        IamResult<List<IamUserByToken>> listIamResult = this.iamService.queryUserBySids(iamTenantUserDTO);
        log.info("invoke iam user info by sid response:{}", (Object)JSONUtils.toJson(iamTenantUserDTO));
        if (CollectionsUtils.notEmpty(listIamResult.getData()).booleanValue()) {
            List<UserInfo> userInfoList = listIamResult.getData().stream().map(IamUserByToken::buildIamUserBase).collect(Collectors.toList());
            return userInfoList;
        }
        return new ArrayList<UserInfo>();
    }

    @Override
    public IamLoginUser login(IamLoginDTO iamLoginDTO) {
        iamLoginDTO.setIdentityType("token");
        log.info("invoke iam login params:{}", (Object)JSONUtils.toJson(iamLoginDTO));
        IamLoginUser loginUser = this.iamService.login(iamLoginDTO);
        log.info("invoke iam login response param:{}", (Object)JSONUtils.toJson(loginUser));
        TokenContext.setIamAuthAppContext(IamConstant.DIGI_MIDDLEWARE_AUTH_APP);
        TokenContext.setIamAuthUserContext(loginUser.getToken());
        IamPermissionUser iamPermissionUser = this.iamService.queryUserPermission();
        List<IamRoles> roles = iamPermissionUser.getResult().getRoles();
        if (CollectionsUtils.notEmpty(roles).booleanValue()) {
            boolean adminFlag = roles.stream().anyMatch(user -> IamConstant.IAM_SUPER_ADMIN_IDENTIFY.equalsIgnoreCase(user.getId()));
            if (adminFlag) {
                loginUser.setUserType(UserType.ADMIN_USER);
            } else {
                loginUser.setUserType(UserType.GENERAL_USER);
            }
            return loginUser;
        }
        loginUser.setUserType(UserType.GENERAL_USER);
        return loginUser;
    }

    @Override
    public boolean isAdmin() {
        IamPermissionUser iamPermissionUser = this.iamService.queryUserPermission();
        log.info("invoke iam user permission info response:{}", (Object)JSONUtils.toJson(iamPermissionUser));
        if (ObjectUtils.isEmpty((Object)iamPermissionUser)) {
            log.error("query iam permission user is null!");
            throw new BusinessException("query iam permission user is null!");
        }
        List<IamRoles> roles = iamPermissionUser.getResult().getRoles();
        if (!CollectionsUtils.notEmpty(roles).booleanValue()) {
            log.error("query iam permission user roles is empty");
            return false;
        }
        return roles.stream().anyMatch(user -> IamConstant.IAM_SUPER_ADMIN_IDENTIFY.equalsIgnoreCase(user.getId()));
    }

    @Override
    public UserType isAdminUserType() {
        boolean adminFlag = this.isAdmin();
        if (adminFlag) {
            return UserType.ADMIN_USER;
        }
        return UserType.GENERAL_USER;
    }

    @Override
    public List<IamPermissions> queryUserPermissionAll() {
        IamPermissionUser iamPermissionUser = this.iamService.queryUserPermission();
        log.info("invoke iam user permission info response:{}", (Object)JSONUtils.toJson(iamPermissionUser));
        List<IamPermissions> permissions = iamPermissionUser.getResult().getPermissions();
        return permissions;
    }

    @Override
    public IamUserTenantList queryUserEmailTenantsAuth(String userId) {
        IamUserDTO iamTenantDTO = IamUserDTO.builder().id(userId).type("0").tenantType(null).appId(this.appId).build();
        IamResult<IamUserTenantList> iamUserTenantListIamResult = this.iamService.queryUserEmailTenantsAuth(iamTenantDTO);
        log.info("invoke iam user permission info response:{}", (Object)JSONUtils.toJson(iamUserTenantListIamResult));
        return iamUserTenantListIamResult.getData();
    }

    @Override
    public List<IamTenant> queryTenantApps() {
        List<IamTenant> iamTenants = this.iamService.queryTenantApps(this.appId);
        return iamTenants;
    }

    @Override
    public IamTenant queryTenantBySid(Long sid) {
        List<IamTenant> iamTenants = this.queryTenantInfo();
        Optional<IamTenant> iamTenant = iamTenants.stream().filter(item -> sid.equals(item.getSid())).findFirst();
        if (iamTenant.isPresent()) {
            return iamTenant.get();
        }
        return null;
    }

    private List<IamTenant> filterTenantInfo(List<IamTenant> iamTenantList) {
        List<IamTenant> list = new ArrayList<IamTenant>();
        switch (this.dmpEnv) {
            case "dev": 
            case "hw_test": {
                list = iamTenantList.stream().filter(iamTenant -> iamTenant.getId().startsWith(this.dmpTenantNameRulePrefix) && iamTenant.getId().endsWith(this.dmpTenantNameRuleSuffix)).collect(Collectors.toList());
                break;
            }
            case "hw_prod": 
            case "hw_demo": {
                list = iamTenantList.stream().filter(iamTenant -> !iamTenant.getId().startsWith(this.dmpTenantNameRulePrefix) || !iamTenant.getId().endsWith(this.dmpTenantNameRuleSuffix)).collect(Collectors.toList());
                break;
            }
            default: {
                list.addAll(iamTenantList);
            }
        }
        return list;
    }

    @Override
    public List<IamOrgAspect> queryOrgAspect(IamOrgAspectDTO iamOrgAspectDTO) {
        return this.iamService.queryOrgAspect(iamOrgAspectDTO);
    }

    @Override
    public List<IamOrgAspect> queryOrgUserInOrg(IamOrgUserDTO iamOrgUserDTO) {
        return this.iamService.queryOrgUserInOrg(iamOrgUserDTO);
    }

    @Override
    public List<IamTenant> queryTenantInfo() {
        List<IamTenant> list = new ArrayList<IamTenant>();
        List<IamTenant> iamTenants = this.iamService.queryTenantInfo(this.appId);
        if (CollectionsUtils.notEmpty(iamTenants).booleanValue()) {
            list = this.filterTenantInfo(iamTenants);
        }
        return list;
    }

    @Override
    public IamLoginUser innerLogin(LoginDTO loginDTO) {
        this.getIamLoginParam(loginDTO);
        IamLoginDTO iamLoginDTO = IamLoginDTO.builder().userId(loginDTO.getUserName()).passwordHash(loginDTO.getUserPassword()).clientEncryptPublicKey(loginDTO.getClientEncryptPublicKey()).build();
        IamLoginUser login = this.login(iamLoginDTO);
        return login;
    }

    @Override
    public LoginDTO getIamLoginParam(LoginDTO loginDTO) {
        try {
            HashMap<String, String> keyMap = this.getKeyPairMap();
            if (CollectionsUtils.notEmpty(keyMap).booleanValue()) {
                String clientPublicKey = keyMap.get("publicKey");
                String privateKey = keyMap.get("privateKey");
                IamPublicKey iamPublicKey = this.iamService.queryPublicKey();
                String encryptPublicKey = RSAUtils.encryptByPublicKey(clientPublicKey, iamPublicKey.getPublicKey());
                IamAesKeyDTO iamAesKeyDTO = IamAesKeyDTO.builder().clientEncryptPublicKey(encryptPublicKey).build();
                IamAesPublicKy iamAesPublicKy = this.iamService.queryAesKey(iamAesKeyDTO);
                String aesKey = new String(RSAUtils.decryptByPrivateKey(Base64.decodeBase64((String)iamAesPublicKy.getEncryptAesKey()), privateKey));
                String passwordHash = AESUtils.aesEncryptByBase64(loginDTO.getMd5UserPassword(), aesKey);
                loginDTO.setUserPassword(passwordHash);
                loginDTO.setClientEncryptPublicKey(encryptPublicKey);
                return loginDTO;
            }
        }
        catch (Exception e) {
            log.error("generate iam login passwordHash error!e:{}", (Throwable)e);
        }
        return loginDTO;
    }

    @Override
    public Result<IamUserByToken> queryIamUserInfoByUserToken() {
        IamUserByToken iamUserByToken = null;
        try {
            iamUserByToken = this.iamService.queryIamUserInfoByUserToken();
        }
        catch (Exception e) {
            return Result.error(Status.AUTHENTICATION_FAIL);
        }
        log.info("invoke iam user info by user token response:{}", (Object)JSONUtils.toJson(iamUserByToken));
        return Result.success(iamUserByToken);
    }

    @Override
    public IamAnalyzeToken identityTokenAnalyze() {
        IamAnalyzeToken iamAnalyzeToken = this.iamService.identityTokenAnalyze();
        log.info("invoke iam identity token analyze response:{}", (Object)JSONUtils.toJson(iamAnalyzeToken));
        return iamAnalyzeToken;
    }

    @Override
    public List<IamAssociationUserInRole> queryAssociationUserInRole(IamRoleDTO iamRoleDTO) {
        log.info("invoke iam association user in role params:{}", (Object)JSONUtils.toJson(iamRoleDTO));
        List<IamAssociationUserInRole> iamAssociationUserInRoles = this.iamService.queryAssociationUserInRole(iamRoleDTO);
        log.info("invoke iam association user in role response:{}", (Object)JSONUtils.toJson(iamAssociationUserInRoles));
        return iamAssociationUserInRoles;
    }

    @Override
    public IamPublicKey queryPublicKey() {
        IamPublicKey iamPublicKey = this.iamService.queryPublicKey();
        return iamPublicKey;
    }

    @Override
    public IamAesPublicKy queryAesKey(IamAesKeyDTO iamAesKeyDTO) {
        return this.iamService.queryAesKey(iamAesKeyDTO);
    }

    @Override
    public IamLoginUser identityTokenRefreshTenant(IamTenantDTO iamTenantDTO) {
        log.info("invoke iam identity token refresh tenant params:{}", (Object)JSONUtils.toJson(iamTenantDTO));
        IamAuthoredUser iamAuthoredUser = this.iamService.identityTokenRefreshTenant(iamTenantDTO);
        log.info("invoke iam identity token refresh tenant response:{}", (Object)JSONUtils.toJson(iamAuthoredUser));
        if (!ObjectUtils.isEmpty((Object)iamAuthoredUser)) {
            return iamAuthoredUser.getAuthoredUser();
        }
        return new IamLoginUser();
    }

    private HashMap<String, String> getKeyPairMap() throws NoSuchAlgorithmException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(1024);
        KeyPair keyPair = generator.generateKeyPair();
        String privateKey = new String(Base64.encodeBase64((byte[])keyPair.getPrivate().getEncoded()));
        String publicKey = new String(Base64.encodeBase64((byte[])keyPair.getPublic().getEncoded()));
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("privateKey", privateKey);
        keyMap.put("publicKey", publicKey);
        return keyMap;
    }
}

