/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.feign.client;

import com.digiwin.commons.entity.dto.daas.ApiStatisticDto;
import com.digiwin.commons.entity.dto.daas.TDapCatalogRelationResourceDTO;
import com.digiwin.commons.entity.dto.dap.TableInfoAopDTO;
import com.digiwin.commons.entity.dto.ds.DsDatasourceInfoDto;
import com.digiwin.commons.entity.dto.ds.DsTableInfoDto;
import com.digiwin.commons.entity.dto.ds.TDapTableBusinessInfoDto;
import com.digiwin.commons.entity.model.DataSource;
import com.digiwin.commons.entity.model.Result;
import com.digiwin.commons.entity.model.User;
import com.digiwin.commons.entity.vo.HomeSearchVO;
import com.digiwin.commons.entity.vo.ds.TDsDatasourceVO;
import com.digiwin.commons.entity.vo.ds.WorkflowVO;
import com.digiwin.commons.feign.conf.FeignGlobalConfig;
import feign.Request;
import java.util.List;
import org.springframework.cloud.client.ConditionalOnDiscoveryEnabled;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@ConditionalOnDiscoveryEnabled
@FeignClient(value="ds-api-service", path="/dolphinscheduler", configuration={FeignGlobalConfig.class})
public interface DsService {
    @RequestMapping(value={"${daas.api.ds-home-page-api-statistic}"}, method={RequestMethod.POST})
    @ResponseBody
    public Result<ApiStatisticDto> queryApiStatisticInfo();

    @ResponseBody
    @PostMapping(value={"${dolphinscheduler.check-session}"})
    public Object checkSession(String var1);

    @GetMapping(value={"/users/query-user-by-name"})
    public Object queryUserByName(@RequestParam(value="userName") String var1);

    @PostMapping(value={"/authenticate"})
    public Result<User> authenticate(@RequestParam(value="sessionId", required=false) String var1, @RequestParam(value="token", required=false) String var2);

    @RequestMapping(value={"${dolphinscheduler.api.query-datasource-by-warehouse}"}, method={RequestMethod.GET})
    @ResponseBody
    public Result queryDatasourceInfoByWarehouse(@RequestParam(value="dataWarehouseId") Integer var1);

    @RequestMapping(value={"${dolphinscheduler.api.query-table-by-id}"}, method={RequestMethod.GET})
    @ResponseBody
    public Result queryTableById(@RequestParam(value="id") Integer var1);

    @RequestMapping(value={"${dolphinscheduler.api.bind-catalog}"}, method={RequestMethod.POST})
    @ResponseBody
    public Result bindCatalogToResource(@RequestBody TDapCatalogRelationResourceDTO var1, Request.Options var2);

    @RequestMapping(value={"${dolphinscheduler.api.get-datasource-id}"}, method={RequestMethod.POST})
    @ResponseBody
    public Result queryDatasourceId(@RequestBody TableInfoAopDTO var1);

    @RequestMapping(value={"${dolphinscheduler.api.query-batch-datasource}"}, method={RequestMethod.POST})
    @ResponseBody
    public Result queryDatasourceByIds(@RequestBody List<Integer> var1);

    @RequestMapping(value={"${dolphinscheduler.api.tag.query-ds-tag-all}"}, method={RequestMethod.POST})
    @ResponseBody
    public Result queryDsTagAll();

    @RequestMapping(value={"${dolphinscheduler.api.tag.query-ds-table-tag-relation-all}"}, method={RequestMethod.POST})
    @ResponseBody
    public Result queryTableTagRelationInfo();

    @PostMapping(value={"${dolphinscheduler.api.query-user-id-by-token}"})
    public Result<Integer> queryUserIdByToken(@RequestParam(value="token") String var1);

    @PostMapping(value={"${dolphinscheduler.datasource-by-id}"})
    public Result<DsDatasourceInfoDto> queryDataSourceById(@RequestParam(value="id") int var1);

    @PostMapping(value={"${dolphinscheduler.query-datasource-info}"})
    public Result<List<DataSource>> queryDatasourceInfo(@RequestBody TDsDatasourceVO var1);

    @PostMapping(value={"${dolphinscheduler.query-datasource-details}"})
    public Result<DataSource> queryDatasourceDetails(@RequestBody TDsDatasourceVO var1);

    @PostMapping(value={"${dolphinscheduler.query-datasource-tag}"})
    public Result<HomeSearchVO> getDataSourceAndTagByTable(@RequestBody DsTableInfoDto var1);

    @GetMapping(value={"${dolphinscheduler.table-business-query}"})
    public Result<TDapTableBusinessInfoDto> queryTableBusinessInfo(@RequestParam(value="datasourceId") Integer var1, @RequestParam(value="tableCode") String var2, @RequestParam(value="isDel") Integer var3);

    @GetMapping(value={"${dolphinscheduler.workflow-query}"})
    public Result<List<WorkflowVO>> queryDefineListByIds(@RequestParam(value="ids", defaultValue="") String var1);
}

