/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.service.impl;

import com.digiwin.commons.context.TokenContext;
import com.digiwin.commons.entity.constant.IamConstant;
import com.digiwin.commons.entity.dto.iam.IamLoginDTO;
import com.digiwin.commons.entity.dto.iam.IamOrgAspectDTO;
import com.digiwin.commons.entity.dto.iam.IamOrgUserDTO;
import com.digiwin.commons.entity.enums.UserType;
import com.digiwin.commons.entity.model.UserInfo;
import com.digiwin.commons.entity.model.iam.IamLoginUser;
import com.digiwin.commons.entity.model.iam.IamOrgAspect;
import com.digiwin.commons.entity.model.iam.IamPermissionUser;
import com.digiwin.commons.entity.model.iam.IamPermissions;
import com.digiwin.commons.entity.model.iam.IamRoles;
import com.digiwin.commons.entity.model.iam.IamTenant;
import com.digiwin.commons.feign.client.IamService;
import com.digiwin.commons.service.IamBusinessService;
import com.digiwin.commons.utils.CollectionsUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class IamBusinessServiceImpl
implements IamBusinessService {
    private static final Logger log = LoggerFactory.getLogger(IamBusinessServiceImpl.class);
    @Autowired
    private IamService iamService;

    @Override
    public UserInfo queryUserInfoBySid(Long sid) {
        return null;
    }

    @Override
    public IamLoginUser login(IamLoginDTO iamLoginDTO) {
        IamLoginUser loginUser = this.iamService.login(iamLoginDTO);
        TokenContext.setIamAuthAppContext(IamConstant.DIGI_MIDDLEWARE_AUTH_APP);
        TokenContext.setIamAuthUserContext(loginUser.getToken());
        IamPermissionUser iamPermissionUser = this.iamService.queryUserPermission();
        List<IamRoles> roles = iamPermissionUser.getResult().getRoles();
        if (CollectionsUtils.notEmpty(roles).booleanValue()) {
            boolean adminFlag = roles.stream().anyMatch(user -> IamConstant.IAM_SUPER_ADMIN_IDENTIFY.equalsIgnoreCase(user.getId()));
            if (adminFlag) {
                loginUser.setUserType(UserType.ADMIN_USER);
            } else {
                loginUser.setUserType(UserType.GENERAL_USER);
            }
            return loginUser;
        }
        loginUser.setUserType(UserType.GENERAL_USER);
        return loginUser;
    }

    @Override
    public boolean isAdmin() {
        List<IamRoles> roles;
        IamPermissionUser iamPermissionUser = this.iamService.queryUserPermission();
        if (ObjectUtils.isEmpty((Object)iamPermissionUser)) {
            log.error("query iam permission user error");
        }
        if (!CollectionsUtils.notEmpty(roles = iamPermissionUser.getResult().getRoles()).booleanValue()) {
            log.error("query iam permission user roles is empty");
            return false;
        }
        return roles.stream().anyMatch(user -> IamConstant.IAM_SUPER_ADMIN_IDENTIFY.equalsIgnoreCase(user.getId()));
    }

    @Override
    public List<IamPermissions> queryUserPermissionAll() {
        IamPermissionUser iamPermissionUser = this.iamService.queryUserPermission();
        List<IamPermissions> permissions = iamPermissionUser.getResult().getPermissions();
        return permissions;
    }

    @Override
    public IamTenant queryTenantApps(String appId) {
        return this.iamService.queryTenantApps(appId);
    }

    @Override
    public List<IamOrgAspect> queryOrgAspect(IamOrgAspectDTO iamOrgAspectDTO) {
        return this.iamService.queryOrgAspect(iamOrgAspectDTO);
    }

    @Override
    public List<IamOrgAspect> queryOrgUserInOrg(IamOrgUserDTO iamOrgUserDTO) {
        return this.iamService.queryOrgUserInOrg(iamOrgUserDTO);
    }
}

