/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.service.impl;

import com.digiwin.commons.context.TokenContext;
import com.digiwin.commons.entity.constant.IamConstant;
import com.digiwin.commons.entity.dto.iam.IamLoginDTO;
import com.digiwin.commons.entity.dto.iam.IamOrgAspectDTO;
import com.digiwin.commons.entity.dto.iam.IamOrgUserDTO;
import com.digiwin.commons.entity.dto.iam.IamTenantUserDTO;
import com.digiwin.commons.entity.dto.iam.IamUserBaseSIdDTO;
import com.digiwin.commons.entity.enums.Status;
import com.digiwin.commons.entity.enums.UserType;
import com.digiwin.commons.entity.model.UserInfo;
import com.digiwin.commons.entity.model.iam.IamLoginUser;
import com.digiwin.commons.entity.model.iam.IamOrgAspect;
import com.digiwin.commons.entity.model.iam.IamPermissionUser;
import com.digiwin.commons.entity.model.iam.IamPermissions;
import com.digiwin.commons.entity.model.iam.IamResult;
import com.digiwin.commons.entity.model.iam.IamRoles;
import com.digiwin.commons.entity.model.iam.IamTenant;
import com.digiwin.commons.entity.model.iam.IamTenantUser;
import com.digiwin.commons.entity.model.iam.IamUserByToken;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.feign.client.IamService;
import com.digiwin.commons.service.IamBusinessService;
import com.digiwin.commons.utils.CollectionsUtils;
import com.digiwin.commons.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnProperty(name={"iam.feign.enable"}, havingValue="true")
public class IamBusinessServiceImpl
implements IamBusinessService {
    private static final Logger log = LoggerFactory.getLogger(IamBusinessServiceImpl.class);
    @Autowired
    private IamService iamService;

    @Override
    public List<UserInfo> queryUserInfoByNameContent(IamTenantUserDTO iamTenantUserDTO) {
        IamResult<IamTenantUser> iamTenantUserResult = this.iamService.queryTenantAuthUsers(iamTenantUserDTO);
        if (!iamTenantUserResult.isSuccess()) {
            log.error("query iam tenant user error");
            throw new BusinessException(Status.QUERY_IAM_TENANT_USER_ERROR);
        }
        return iamTenantUserResult.getData().getList().stream().map(IamUserByToken::buildIamUserBase).collect(Collectors.toList());
    }

    @Override
    public Optional<UserInfo> queryUserInfoByName(String userName) {
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().userName(userName).build();
        IamResult<IamTenantUser> iamTenantUserResult = this.iamService.queryTenantAuthUsers(iamTenantUserDTO);
        if (!iamTenantUserResult.isSuccess()) {
            log.error("query iam tenant user error");
            throw new BusinessException(Status.QUERY_IAM_TENANT_USER_ERROR);
        }
        if (CollectionUtils.isEmpty(iamTenantUserResult.getData().getList())) {
            return Optional.empty();
        }
        UserInfo userInfo = (UserInfo)iamTenantUserResult.getData().getList().stream().map(IamUserByToken::buildIamUserBase).collect(Collectors.toList()).get(0);
        return Optional.of(userInfo);
    }

    @Override
    public boolean checkUserSidByNameIsEmpty(String userContent, IamUserBaseSIdDTO iamUserBaseSIdDTO) {
        if (StringUtils.isBlank(userContent)) {
            log.info("param user content is empty");
            iamUserBaseSIdDTO.setSidList(Collections.emptyList());
            return false;
        }
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().userContent(userContent).build();
        List<Long> sIdList = this.queryUserInfoByNameContent(iamTenantUserDTO).stream().map(UserInfo::getSid).collect(Collectors.toList());
        iamUserBaseSIdDTO.setSidList(sIdList);
        return CollectionUtils.isEmpty(sIdList);
    }

    @Override
    public Optional<UserInfo> queryUserInfoBySid(Long sid) {
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().userSid(Collections.singletonList(sid)).build();
        IamResult<IamTenantUser> iamTenantUserIamResult = this.iamService.queryTenantAuthUsers(iamTenantUserDTO);
        if (!iamTenantUserIamResult.isSuccess()) {
            log.error("query iam tenant user error");
            throw new BusinessException(Status.QUERY_IAM_TENANT_USER_ERROR);
        }
        if (CollectionsUtils.notEmpty(iamTenantUserIamResult.getData().getList()).booleanValue()) {
            List userInfoList = iamTenantUserIamResult.getData().getList().stream().map(IamUserByToken::buildIamUserBase).collect(Collectors.toList());
            return Optional.of(userInfoList.get(0));
        }
        return Optional.empty();
    }

    @Override
    public List<UserInfo> queryBatchUserInfoBySidList(List<Long> userSid) {
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().userSid(userSid).build();
        IamResult<IamTenantUser> iamTenantUserIamResult = this.iamService.queryTenantAuthUsers(iamTenantUserDTO);
        if (!iamTenantUserIamResult.isSuccess()) {
            log.error("query iam tenant user error");
            throw new BusinessException(Status.QUERY_IAM_TENANT_USER_ERROR);
        }
        if (CollectionsUtils.notEmpty(iamTenantUserIamResult.getData().getList()).booleanValue()) {
            List<UserInfo> userInfoList = iamTenantUserIamResult.getData().getList().stream().map(IamUserByToken::buildIamUserBase).collect(Collectors.toList());
            return userInfoList;
        }
        return new ArrayList<UserInfo>();
    }

    @Override
    public IamLoginUser login(IamLoginDTO iamLoginDTO) {
        IamLoginUser loginUser = this.iamService.login(iamLoginDTO);
        TokenContext.setIamAuthAppContext(IamConstant.DIGI_MIDDLEWARE_AUTH_APP);
        TokenContext.setIamAuthUserContext(loginUser.getToken());
        IamPermissionUser iamPermissionUser = this.iamService.queryUserPermission();
        List<IamRoles> roles = iamPermissionUser.getResult().getRoles();
        if (CollectionsUtils.notEmpty(roles).booleanValue()) {
            boolean adminFlag = roles.stream().anyMatch(user -> IamConstant.IAM_SUPER_ADMIN_IDENTIFY.equalsIgnoreCase(user.getId()));
            if (adminFlag) {
                loginUser.setUserType(UserType.ADMIN_USER);
            } else {
                loginUser.setUserType(UserType.GENERAL_USER);
            }
            return loginUser;
        }
        loginUser.setUserType(UserType.GENERAL_USER);
        return loginUser;
    }

    @Override
    public boolean isAdmin() {
        IamPermissionUser iamPermissionUser = this.iamService.queryUserPermission();
        if (ObjectUtils.isEmpty((Object)iamPermissionUser)) {
            log.error("query iam permission user error");
            throw new BusinessException("query iam permission user error");
        }
        List<IamRoles> roles = iamPermissionUser.getResult().getRoles();
        if (!CollectionsUtils.notEmpty(roles).booleanValue()) {
            log.error("query iam permission user roles is empty");
            return false;
        }
        return roles.stream().anyMatch(user -> IamConstant.IAM_SUPER_ADMIN_IDENTIFY.equalsIgnoreCase(user.getId()));
    }

    @Override
    public UserType isAdminUserType() {
        boolean adminFlag = this.isAdmin();
        if (adminFlag) {
            return UserType.ADMIN_USER;
        }
        return UserType.GENERAL_USER;
    }

    @Override
    public List<IamPermissions> queryUserPermissionAll() {
        IamPermissionUser iamPermissionUser = this.iamService.queryUserPermission();
        List<IamPermissions> permissions = iamPermissionUser.getResult().getPermissions();
        return permissions;
    }

    @Override
    public IamTenant queryTenantApps(String appId) {
        return this.iamService.queryTenantApps(appId);
    }

    @Override
    public List<IamOrgAspect> queryOrgAspect(IamOrgAspectDTO iamOrgAspectDTO) {
        return this.iamService.queryOrgAspect(iamOrgAspectDTO);
    }

    @Override
    public List<IamOrgAspect> queryOrgUserInOrg(IamOrgUserDTO iamOrgUserDTO) {
        return this.iamService.queryOrgUserInOrg(iamOrgUserDTO);
    }
}

