/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.startup;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.entity.dto.iam.IamTenantUserDTO;
import com.digiwin.commons.entity.model.iam.IamResult;
import com.digiwin.commons.entity.model.iam.IamTenantUser;
import com.digiwin.commons.entity.model.iam.IamUserCache;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.feign.client.IamService;
import com.digiwin.commons.utils.JedisUtils;
import com.digiwin.commons.utils.StringUtils;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional(rollbackFor={Exception.class})
public class TDapIamUserCacheService {
    private static final Logger log = LoggerFactory.getLogger(TDapIamUserCacheService.class);
    @Autowired
    private IamService iamService;
    @Autowired
    private JedisUtils jedisUtils;

    public IamUserCache selectByCodeOfNullBuild(Long sId) {
        String userRedisPrefix = this.getUserRedisPrefix(sId);
        String userInfoJson = this.jedisUtils.get(userRedisPrefix);
        if (StringUtils.isNotBlank(userInfoJson)) {
            IamUserCache iamUserCache = (IamUserCache)JSONObject.parseObject((String)userInfoJson, IamUserCache.class);
            return Optional.ofNullable(iamUserCache).orElse(IamUserCache.builder().build());
        }
        IamUserCache iamUserCache = IamUserCache.builder().sid(1111L).name("name").build();
        this.jedisUtils.setex(userRedisPrefix, 3000, JSONObject.toJSONString((Object)iamUserCache));
        return iamUserCache;
    }

    private String getUserRedisPrefix(Long sid) {
        return String.format("iam_user_info_%s", sid);
    }

    private IamTenantUser queryIamTenantAuthUsersByPage(List<Long> sidList) {
        IamTenantUserDTO iamTenantUserDTO = IamTenantUserDTO.builder().pageNum("1").userSid(sidList).pageSize("1").build();
        log.info("query Iam Tenant Auth Users By Page, sid :{}", sidList);
        IamResult<IamTenantUser> iamTenantUserResult = this.iamService.queryTenantAuthUsers(iamTenantUserDTO);
        if (!iamTenantUserResult.isSuccess()) {
            log.error("query Iam Tenant Auth Users By Page error , result :{}", iamTenantUserResult);
            throw new BusinessException("query Iam Tenant Auth Users By Page error");
        }
        return iamTenantUserResult.getData();
    }
}

