/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.service.impl;

import com.digiwin.commons.context.TokenContext;
import com.digiwin.commons.entity.constant.IamConstant;
import com.digiwin.commons.entity.dto.iam.IamLoginDTO;
import com.digiwin.commons.entity.dto.iam.IamOrgAspectDTO;
import com.digiwin.commons.entity.dto.iam.IamOrgUserDTO;
import com.digiwin.commons.entity.dto.iam.IamTenantUserDTO;
import com.digiwin.commons.entity.dto.iam.IamUserBaseSIdDTO;
import com.digiwin.commons.entity.enums.UserType;
import com.digiwin.commons.entity.model.UserInfo;
import com.digiwin.commons.entity.model.iam.IamLoginUser;
import com.digiwin.commons.entity.model.iam.IamOrgAspect;
import com.digiwin.commons.entity.model.iam.IamPermissionUser;
import com.digiwin.commons.entity.model.iam.IamPermissions;
import com.digiwin.commons.entity.model.iam.IamRoles;
import com.digiwin.commons.entity.model.iam.IamTenant;
import com.digiwin.commons.feign.client.IamService;
import com.digiwin.commons.service.IamBusinessService;
import com.digiwin.commons.utils.CollectionsUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"iam.feign.enable"}, havingValue="true")
public class IamBusinessServiceImpl
implements IamBusinessService {
    private static final Logger log = LoggerFactory.getLogger(IamBusinessServiceImpl.class);
    @Autowired
    private IamService iamService;
    @Value(value="${dmp.env}")
    private String dmpEnv;
    @Value(value="${dmp.tenant-name-rule.prefix}")
    private String dmpTenantNameRulePrefix;
    @Value(value="${dmp.tenant-name-rule.suffix}")
    private String dmpTenantNameRuleSuffix;
    @Value(value="${iam.digi-middleware-auth-app}")
    private String appId;

    private UserInfo createUser() {
        UserInfo userInfo = UserInfo.builder().sid(1L).userId("1L").userName("admin").userType(UserType.ADMIN_USER).tenantId(1L).build();
        return userInfo;
    }

    @Override
    public List<UserInfo> queryUserInfoByNameContent(IamTenantUserDTO iamTenantUserDTO) {
        return Collections.singletonList(this.createUser());
    }

    @Override
    public Optional<UserInfo> queryUserInfoByName(String userName) {
        return Optional.of(this.createUser());
    }

    @Override
    public boolean checkUserSidByNameIsEmpty(String userContent, IamUserBaseSIdDTO iamUserBaseSIdDTO) {
        return false;
    }

    @Override
    public Optional<UserInfo> queryUserInfoBySid(Long sid) {
        return Optional.of(this.createUser());
    }

    @Override
    public List<UserInfo> queryBatchUserInfoBySidList(List<Long> userSid) {
        return Collections.singletonList(this.createUser());
    }

    @Override
    public IamLoginUser login(IamLoginDTO iamLoginDTO) {
        IamLoginUser loginUser = this.iamService.login(iamLoginDTO);
        TokenContext.setIamAuthAppContext(IamConstant.DIGI_MIDDLEWARE_AUTH_APP);
        TokenContext.setIamAuthUserContext(loginUser.getToken());
        IamPermissionUser iamPermissionUser = this.iamService.queryUserPermission();
        List<IamRoles> roles = iamPermissionUser.getResult().getRoles();
        if (CollectionsUtils.notEmpty(roles).booleanValue()) {
            boolean adminFlag = roles.stream().anyMatch(user -> IamConstant.IAM_SUPER_ADMIN_IDENTIFY.equalsIgnoreCase(user.getId()));
            if (adminFlag) {
                loginUser.setUserType(UserType.ADMIN_USER);
            } else {
                loginUser.setUserType(UserType.GENERAL_USER);
            }
            return loginUser;
        }
        loginUser.setUserType(UserType.GENERAL_USER);
        return loginUser;
    }

    @Override
    public boolean isAdmin() {
        return true;
    }

    @Override
    public UserType isAdminUserType() {
        boolean adminFlag = this.isAdmin();
        if (adminFlag) {
            return UserType.ADMIN_USER;
        }
        return UserType.GENERAL_USER;
    }

    @Override
    public List<IamPermissions> queryUserPermissionAll() {
        IamPermissionUser iamPermissionUser = this.iamService.queryUserPermission();
        List<IamPermissions> permissions = iamPermissionUser.getResult().getPermissions();
        return permissions;
    }

    @Override
    public List<IamTenant> queryTenantApps() {
        List<IamTenant> list = new ArrayList<IamTenant>();
        List<IamTenant> iamTenants = this.iamService.queryTenantApps(this.appId);
        if (CollectionsUtils.notEmpty(iamTenants).booleanValue()) {
            list = this.filterTenantInfo(iamTenants);
        }
        return list;
    }

    @Override
    public IamTenant queryTenantBySid(Long sid) {
        List<IamTenant> iamTenants = this.queryTenantApps();
        Optional<IamTenant> iamTenant = iamTenants.stream().filter(item -> sid.equals(item.getSid())).findFirst();
        if (iamTenant.isPresent()) {
            return iamTenant.get();
        }
        return null;
    }

    private List<IamTenant> filterTenantInfo(List<IamTenant> iamTenantList) {
        List<IamTenant> list = new ArrayList<IamTenant>();
        switch (this.dmpEnv) {
            case "dev": 
            case "hw_test": {
                list = iamTenantList.stream().filter(iamTenant -> iamTenant.getName().startsWith(this.dmpTenantNameRulePrefix) && iamTenant.getName().endsWith(this.dmpTenantNameRuleSuffix)).collect(Collectors.toList());
                break;
            }
            case "hw_prod": 
            case "hw_demo": {
                list = iamTenantList.stream().filter(iamTenant -> !iamTenant.getName().startsWith(this.dmpTenantNameRulePrefix) || !iamTenant.getName().endsWith(this.dmpTenantNameRuleSuffix)).collect(Collectors.toList());
                break;
            }
            default: {
                list.addAll(iamTenantList);
            }
        }
        return list;
    }

    @Override
    public List<IamOrgAspect> queryOrgAspect(IamOrgAspectDTO iamOrgAspectDTO) {
        return this.iamService.queryOrgAspect(iamOrgAspectDTO);
    }

    @Override
    public List<IamOrgAspect> queryOrgUserInOrg(IamOrgUserDTO iamOrgUserDTO) {
        return this.iamService.queryOrgUserInOrg(iamOrgUserDTO);
    }
}

