/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.aspect;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.digiwin.commons.annotation.TrackingPoint;
import com.digiwin.commons.context.OperationLogContext;
import com.digiwin.commons.context.SpringApplicationContext;
import com.digiwin.commons.context.UserInfoContext;
import com.digiwin.commons.entity.enums.TrackingType;
import com.digiwin.commons.entity.model.OperationLogPersists;
import com.digiwin.commons.entity.model.UserInfo;
import com.digiwin.commons.utils.ELUtils;
import com.digiwin.commons.utils.StringUtils;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.Optional;
import org.apache.skywalking.apm.toolkit.trace.Trace;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Aspect
@Order(value=10)
@Component
public class SensitiveOperationLogAspect {
    private static final Logger log = LoggerFactory.getLogger(SensitiveOperationLogAspect.class);

    @Pointcut(value="@annotation(org.apache.dolphinscheduler.api.aspect.TrackingPoint)")
    public void pointcut() {
    }

    @Trace
    @Before(value="pointcut()")
    public void preProceeding(JoinPoint joinPoint) {
        OperationLogPersists.OperationLogPersistsBuilder builder = OperationLogPersists.builder();
        builder.reqTime(LocalDateTime.now());
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        TrackingPoint trackingPoint = method.getAnnotation(TrackingPoint.class);
        if (Objects.isNull(trackingPoint)) {
            return;
        }
        String notes = Optional.ofNullable(trackingPoint.title()).filter(StringUtils::isNotBlank).orElseGet(() -> Optional.ofNullable(method.getAnnotation(ApiOperation.class)).map(i -> i.notes()).filter(StringUtils::isNotBlank).orElse(""));
        TrackingType trackingType = trackingPoint.trackingType();
        switch (trackingType) {
            case UPDATE: 
            case DELETE: {
                SensitiveOperationLogAspect.getOldModuleObject(joinPoint, trackingPoint, builder);
            }
        }
        String moduleAlice = trackingPoint.moduleAlice();
        UserInfo context = UserInfoContext.getContext();
        String traceId = TraceContext.traceId();
        OperationLogPersists opLog = builder.traceId(traceId).userInfo(context).moduleName(moduleAlice).trackingType(trackingType).methodDesc(notes).build();
        OperationLogContext.setContext(opLog);
        log.info("moduleAlice: {} , operation: {} ", (Object)moduleAlice, (Object)trackingType);
    }

    private static Object getOldModuleObject(JoinPoint joinPoint, TrackingPoint trackingPoint, OperationLogPersists.OperationLogPersistsBuilder builder) {
        Object[] args = joinPoint.getArgs();
        Object eval = trackingPoint.trackingType().equals((Object)TrackingType.DELETE) ? args[0] : ELUtils.eval(trackingPoint.id(), args[0]);
        Object bean = SpringApplicationContext.getBean(trackingPoint.tracker());
        String expression = TrackingPoint.Expression.getTrackingEL(eval.toString());
        Object oldData = ELUtils.eval(expression, bean);
        return builder.newData(args[0]).rowData(oldData);
    }

    @AfterReturning(value="pointcut()", returning="result")
    public void afterReturning(JoinPoint joinPoint, Object result) {
        this.postProceeding(result, null);
    }

    @AfterThrowing(value="pointcut()", throwing="ex")
    public void afterReturning(JoinPoint joinPoint, Throwable ex) {
        this.postProceeding(null, ex);
    }

    private void postProceeding(Object result, Throwable ex) {
        LocalDateTime now = LocalDateTime.now();
        OperationLogPersists context = OperationLogContext.getContext();
        context.setReqEndTime(now);
        Long elapse = LocalDateTimeUtil.between((LocalDateTime)context.getReqTime(), (LocalDateTime)now, (ChronoUnit)ChronoUnit.MILLIS);
        context.setElapse(elapse);
        Optional.ofNullable(ex).map(i -> i.getMessage()).ifPresent(i -> context.setErrorMsg((String)i));
        Optional.ofNullable(result).filter(Objects::nonNull).ifPresent(i -> context.setResult(i));
        OperationLogContext.clearContext();
        log.info("OperationLogPersists :{}", (Object)context);
    }
}

