/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.enums;

import org.springframework.util.ObjectUtils;

public enum TrackingType {
    CREATE(1, "create"),
    DELETE(2, "delete"),
    UPDATE(3, "update"),
    SELECT(4, "select"),
    LOGIN(20, "login"),
    LOGIN_OUT(21, "login out"),
    IMPORT(22, "import"),
    EXPORT(23, "export"),
    TABLE_CARRY_OUT(24, "table carry out");

    private final int code;
    private final String desc;

    private TrackingType(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer code(String name) {
        if (name == null) {
            return null;
        }
        for (TrackingType ty : TrackingType.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.name(), (Object)name)) continue;
            return ty.getCode();
        }
        return null;
    }

    public static TrackingType of(String desc) {
        for (TrackingType ty : TrackingType.values()) {
            if (!ObjectUtils.nullSafeEquals((Object)ty.getDesc(), (Object)desc)) continue;
            return ty;
        }
        return null;
    }

    public static Integer of(int type) {
        for (TrackingType ty : TrackingType.values()) {
            if (ty.getCode() != type) continue;
            return ty.getCode();
        }
        return null;
    }

    public int getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }
}

