/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.feign.conf;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.commons.context.TokenContext;
import com.digiwin.commons.context.UserInfoContext;
import com.digiwin.commons.utils.StringUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;

public class FeignGlobalConfig
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(FeignGlobalConfig.class);

    public void apply(RequestTemplate requestTemplate) {
        this.isNotBlankSetHeader("digi-middleware-auth-app", TokenContext.getIamAuthAppContext(), requestTemplate);
        this.isNotBlankSetHeader("digi-middleware-auth-user", TokenContext.getIamAuthUserContext(), requestTemplate);
        this.isNotBlankSetHeader("token", TokenContext.getTokenContext(), requestTemplate);
        log.info("user info : {}", (Object)UserInfoContext.getContextHolder());
        if (!ObjectUtils.isEmpty((Object)UserInfoContext.getContextHolder())) {
            String userInfo = JSONObject.toJSONString((Object)UserInfoContext.getContextHolder());
            log.info("user info : {}", (Object)userInfo);
            this.isNotBlankSetHeader("userInfo", userInfo, requestTemplate);
        }
    }

    private void isNotBlankSetHeader(String key, String value, RequestTemplate requestTemplate) {
        if (StringUtils.isNotBlank(key) && StringUtils.isNotBlank(value)) {
            requestTemplate.header(key, new String[]{value});
        }
    }
}

