/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.configuration;

import cn.hutool.core.codec.Base64;
import com.digiwin.commons.processor.es.httpclient.HttpIndicesClient;
import com.digiwin.commons.processor.es.httpclient.HttpOprationEsClient;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@DependsOn
@Configuration
@ConfigurationProperties(prefix="default.elastic")
@ConditionalOnProperty(name={"default.elastic.enable"}, havingValue="true")
public class ElasticSearchConfig {
    private String user;
    private String password;
    @Value(value="cluster-host")
    private String clusterHost;

    @Bean
    public RestHighLevelClient restHighLevelClient() {
        List<String> clusterHostList = Arrays.asList(this.clusterHost.split(","));
        HttpHost[] httpHosts = new HttpHost[clusterHostList.size()];
        for (int i = 0; i < clusterHostList.size(); ++i) {
            String[] hostArray = clusterHostList.get(i).split(":");
            httpHosts[i] = new HttpHost(hostArray[0], Integer.valueOf(hostArray[1]).intValue());
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.user, this.password));
        return new RestHighLevelClient(RestClient.builder((HttpHost[])httpHosts).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
            final /* synthetic */ CredentialsProvider val$credentialsProvider;
            {
                this.val$credentialsProvider = credentialsProvider;
            }

            public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
            }
        }));
    }

    @Bean
    public HttpOprationEsClient httpOprationEsClient() {
        List<String> clusterHostList = Arrays.asList(this.clusterHost.split(","));
        String clusterHost = clusterHostList.get(0);
        String[] clusterHostArray = clusterHost.split(":");
        String host = clusterHostArray[0];
        String port = clusterHostArray[1];
        HttpOprationEsClient httpOprationEsClient = new HttpOprationEsClient();
        httpOprationEsClient.setAddress(host);
        httpOprationEsClient.setUser(this.user);
        httpOprationEsClient.setPassword(this.password);
        httpOprationEsClient.setPort(port);
        httpOprationEsClient.setHttpBasicAccount("Basic " + Base64.encode((byte[])(httpOprationEsClient.getUser() + ":" + httpOprationEsClient.getPassword()).getBytes()));
        httpOprationEsClient.setHttpUrl(String.format("http://%s:%s", httpOprationEsClient.getAddress(), httpOprationEsClient.getPort()));
        httpOprationEsClient.setHttpIndicesClient(new HttpIndicesClient(httpOprationEsClient));
        return httpOprationEsClient;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getClusterHost() {
        return this.clusterHost;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setClusterHost(String clusterHost) {
        this.clusterHost = clusterHost;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticSearchConfig)) {
            return false;
        }
        ElasticSearchConfig other = (ElasticSearchConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$clusterHost = this.getClusterHost();
        String other$clusterHost = other.getClusterHost();
        return !(this$clusterHost == null ? other$clusterHost != null : !this$clusterHost.equals(other$clusterHost));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticSearchConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $clusterHost = this.getClusterHost();
        result = result * 59 + ($clusterHost == null ? 43 : $clusterHost.hashCode());
        return result;
    }

    public String toString() {
        return "ElasticSearchConfig(user=" + this.getUser() + ", password=" + this.getPassword() + ", clusterHost=" + this.getClusterHost() + ")";
    }
}

