/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.entity.model.iam.user;

import com.baomidou.mybatisplus.annotation.TableField;
import com.digiwin.commons.context.SpringApplicationContext;
import com.digiwin.commons.context.TokenContext;
import com.digiwin.commons.entity.model.iam.IamUserCache;
import com.digiwin.commons.startup.TDapIamUserCacheService;
import com.digiwin.commons.utils.StringUtils;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IamBaseUserInfo {
    private static final Logger log = LoggerFactory.getLogger(IamBaseUserInfo.class);
    private Long userId;
    @TableField(exist=false)
    private String userName;

    public void setUserId(Long userId) {
        this.userId = userId;
        if (StringUtils.isEmpty(TokenContext.getIamAuthUserContext())) {
            log.info("userToken is empty");
            return;
        }
        TDapIamUserCacheService tDapIamUserCacheService = SpringApplicationContext.getBean(TDapIamUserCacheService.class);
        IamUserCache iamUserCache = tDapIamUserCacheService.selectByCodeOfNullBuild(userId);
        Optional.ofNullable(iamUserCache).ifPresent(item -> {
            this.userName = iamUserCache.getName();
        });
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IamBaseUserInfo)) {
            return false;
        }
        IamBaseUserInfo other = (IamBaseUserInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        return !(this$userName == null ? other$userName != null : !this$userName.equals(other$userName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IamBaseUserInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        return result;
    }

    public String toString() {
        return "IamBaseUserInfo(userId=" + this.getUserId() + ", userName=" + this.getUserName() + ")";
    }

    public IamBaseUserInfo() {
    }

    public IamBaseUserInfo(Long userId, String userName) {
        this.userId = userId;
        this.userName = userName;
    }
}

