/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.commons.factory;

import com.digiwin.commons.entity.enums.DataCatalogClassificationType;
import com.digiwin.commons.exceptions.BusinessException;
import com.digiwin.commons.processor.assets.DataAssetsBaseProcessor;
import com.digiwin.commons.processor.assets.DataPipelineProcessor;
import com.digiwin.commons.processor.assets.DataQualityProcessor;
import com.digiwin.commons.processor.assets.DataServiceProcessor;
import com.digiwin.commons.processor.assets.DataTableProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="assetsOperateProcessorFactory")
public class AssetsOperateProcessorFactory {
    private static final Logger log = LoggerFactory.getLogger(AssetsOperateProcessorFactory.class);
    private final DataTableProcessor dataTableProcessor;
    private final DataPipelineProcessor dataPipelineProcessor;
    private final DataQualityProcessor dataQualityProcessor;
    private final DataServiceProcessor dataServiceProcessor;

    public DataAssetsBaseProcessor getAssetsProcessor(DataCatalogClassificationType dataCatalogClassificationType) {
        switch (dataCatalogClassificationType) {
            case DATA_TABLE: {
                return this.dataTableProcessor;
            }
            case DATA_API: {
                return this.dataServiceProcessor;
            }
            case DATA_PIPELINE: {
                return this.dataPipelineProcessor;
            }
            case DATA_QUALITY: {
                return this.dataQualityProcessor;
            }
        }
        log.error("un support dataCatalogClassification type: {}", (Object)dataCatalogClassificationType.getDesc());
        throw new BusinessException("not support dataCatalogClassification type");
    }

    @Autowired
    public AssetsOperateProcessorFactory(DataTableProcessor dataTableProcessor, DataPipelineProcessor dataPipelineProcessor, DataQualityProcessor dataQualityProcessor, DataServiceProcessor dataServiceProcessor) {
        this.dataTableProcessor = dataTableProcessor;
        this.dataPipelineProcessor = dataPipelineProcessor;
        this.dataQualityProcessor = dataQualityProcessor;
        this.dataServiceProcessor = dataServiceProcessor;
    }
}

